package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 上传接口返回内容（该接口为异步接口，上传结果通过反馈接口获取）
 */
@ApiModel(description = "上传接口返回内容（该接口为异步接口，上传结果通过反馈接口获取）")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class BillUploadResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private String result = null;

  @JsonIgnore
  public BillUploadResponse code (Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 错误码
   * @return code
  **/
  @ApiModelProperty(value = "错误码")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public BillUploadResponse message (String message) {
    this.message = message;
    return this;
  }

   /**
   * 上传接口异常消息
   * @return message
  **/
  @ApiModelProperty(value = "上传接口异常消息")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public BillUploadResponse result (String result) {
    this.result = result;
    return this;
  }

   /**
   * 上传结果 result
   * @return result
  **/
  @ApiModelProperty(value = "上传结果 result")
  public String getResult() {
    return result;
  }

  public void setResult(String result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BillUploadResponse billUploadResponse = (BillUploadResponse) o;
    return Objects.equals(this.code, billUploadResponse.code) &&
        Objects.equals(this.message, billUploadResponse.message) &&
        Objects.equals(this.result, billUploadResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BillUploadResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
