package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 购方信息
 */
@ApiModel(description = "购方信息")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class BlockChainPurchaserInfo {
  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaserAddress")
  private String purchaserAddress = null;

  @JsonProperty("purchaserTel")
  private String purchaserTel = null;

  @JsonProperty("purchaserEPayId")
  private String purchaserEPayId = null;

  @JsonIgnore
  public BlockChainPurchaserInfo purchaserTaxNo (String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public BlockChainPurchaserInfo purchaserName (String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public BlockChainPurchaserInfo purchaserAddress (String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
    return this;
  }

   /**
   * 购方地址
   * @return purchaserAddress
  **/
  @ApiModelProperty(value = "购方地址")
  public String getPurchaserAddress() {
    return purchaserAddress;
  }

  public void setPurchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
  }

  @JsonIgnore
  public BlockChainPurchaserInfo purchaserTel (String purchaserTel) {
    this.purchaserTel = purchaserTel;
    return this;
  }

   /**
   * 购方电话
   * @return purchaserTel
  **/
  @ApiModelProperty(value = "购方电话")
  public String getPurchaserTel() {
    return purchaserTel;
  }

  public void setPurchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
  }

  @JsonIgnore
  public BlockChainPurchaserInfo purchaserEPayId (String purchaserEPayId) {
    this.purchaserEPayId = purchaserEPayId;
    return this;
  }

   /**
   * 购方电子支付标识
   * @return purchaserEPayId
  **/
  @ApiModelProperty(value = "购方电子支付标识")
  public String getPurchaserEPayId() {
    return purchaserEPayId;
  }

  public void setPurchaserEPayId(String purchaserEPayId) {
    this.purchaserEPayId = purchaserEPayId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BlockChainPurchaserInfo blockChainPurchaserInfo = (BlockChainPurchaserInfo) o;
    return Objects.equals(this.purchaserTaxNo, blockChainPurchaserInfo.purchaserTaxNo) &&
        Objects.equals(this.purchaserName, blockChainPurchaserInfo.purchaserName) &&
        Objects.equals(this.purchaserAddress, blockChainPurchaserInfo.purchaserAddress) &&
        Objects.equals(this.purchaserTel, blockChainPurchaserInfo.purchaserTel) &&
        Objects.equals(this.purchaserEPayId, blockChainPurchaserInfo.purchaserEPayId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(purchaserTaxNo, purchaserName, purchaserAddress, purchaserTel, purchaserEPayId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BlockChainPurchaserInfo {\n");
    
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    purchaserAddress: ").append(toIndentedString(purchaserAddress)).append("\n");
    sb.append("    purchaserTel: ").append(toIndentedString(purchaserTel)).append("\n");
    sb.append("    purchaserEPayId: ").append(toIndentedString(purchaserEPayId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
