package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforcecloud.open.client.model.Response;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * CallbackEventMessage
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class CallbackEventMessage {
  @JsonProperty("customerNo")
  private String customerNo = null;

  @JsonProperty("eventProperties")
  private Map<String, String> eventProperties = new HashMap<String, String>();

  @JsonProperty("eventType")
  private String eventType = null;

  @JsonProperty("originatorNo")
  private String originatorNo = null;

  @JsonProperty("platormNo")
  private String platormNo = null;

  @JsonProperty("response")
  private Response response = null;

  @JsonIgnore
  public CallbackEventMessage customerNo (String customerNo) {
    this.customerNo = customerNo;
    return this;
  }

   /**
   * Get customerNo
   * @return customerNo
  **/
  @ApiModelProperty(value = "")
  public String getCustomerNo() {
    return customerNo;
  }

  public void setCustomerNo(String customerNo) {
    this.customerNo = customerNo;
  }

  @JsonIgnore
  public CallbackEventMessage eventProperties (Map<String, String> eventProperties) {
    this.eventProperties = eventProperties;
    return this;
  }

  public CallbackEventMessage putEventPropertiesItem(String key, String eventPropertiesItem) {
    this.eventProperties.put(key, eventPropertiesItem);
    return this;
  }

   /**
   * Get eventProperties
   * @return eventProperties
  **/
  @ApiModelProperty(value = "")
  public Map<String, String> getEventProperties() {
    return eventProperties;
  }

  public void setEventProperties(Map<String, String> eventProperties) {
    this.eventProperties = eventProperties;
  }

  @JsonIgnore
  public CallbackEventMessage eventType (String eventType) {
    this.eventType = eventType;
    return this;
  }

   /**
   * Get eventType
   * @return eventType
  **/
  @ApiModelProperty(value = "")
  public String getEventType() {
    return eventType;
  }

  public void setEventType(String eventType) {
    this.eventType = eventType;
  }

  @JsonIgnore
  public CallbackEventMessage originatorNo (String originatorNo) {
    this.originatorNo = originatorNo;
    return this;
  }

   /**
   * Get originatorNo
   * @return originatorNo
  **/
  @ApiModelProperty(value = "")
  public String getOriginatorNo() {
    return originatorNo;
  }

  public void setOriginatorNo(String originatorNo) {
    this.originatorNo = originatorNo;
  }

  @JsonIgnore
  public CallbackEventMessage platormNo (String platormNo) {
    this.platormNo = platormNo;
    return this;
  }

   /**
   * Get platormNo
   * @return platormNo
  **/
  @ApiModelProperty(value = "")
  public String getPlatormNo() {
    return platormNo;
  }

  public void setPlatormNo(String platormNo) {
    this.platormNo = platormNo;
  }

  @JsonIgnore
  public CallbackEventMessage response (Response response) {
    this.response = response;
    return this;
  }

   /**
   * Get response
   * @return response
  **/
  @ApiModelProperty(value = "")
  public Response getResponse() {
    return response;
  }

  public void setResponse(Response response) {
    this.response = response;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CallbackEventMessage callbackEventMessage = (CallbackEventMessage) o;
    return Objects.equals(this.customerNo, callbackEventMessage.customerNo) &&
        Objects.equals(this.eventProperties, callbackEventMessage.eventProperties) &&
        Objects.equals(this.eventType, callbackEventMessage.eventType) &&
        Objects.equals(this.originatorNo, callbackEventMessage.originatorNo) &&
        Objects.equals(this.platormNo, callbackEventMessage.platormNo) &&
        Objects.equals(this.response, callbackEventMessage.response);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerNo, eventProperties, eventType, originatorNo, platormNo, response);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CallbackEventMessage {\n");
    
    sb.append("    customerNo: ").append(toIndentedString(customerNo)).append("\n");
    sb.append("    eventProperties: ").append(toIndentedString(eventProperties)).append("\n");
    sb.append("    eventType: ").append(toIndentedString(eventType)).append("\n");
    sb.append("    originatorNo: ").append(toIndentedString(originatorNo)).append("\n");
    sb.append("    platormNo: ").append(toIndentedString(platormNo)).append("\n");
    sb.append("    response: ").append(toIndentedString(response)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
