package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 定制打印控制项详细说明见wiki:&lt;https://wiki.xforceplus.com/pages/viewpage.action?pageId&#x3D;24019173&gt;
 */
@ApiModel(description = "定制打印控制项详细说明见wiki:<https://wiki.xforceplus.com/pages/viewpage.action?pageId=24019173>")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class CustomPrintControl {
  @JsonProperty("template")
  private String template = null;

  @JsonProperty("customPrintInfo")
  private Map<String, String> customPrintInfo = new HashMap<String, String>();

  @JsonIgnore
  public CustomPrintControl template (String template) {
    this.template = template;
    return this;
  }

   /**
   * 版式(详见上面wiki)
   * @return template
  **/
  @ApiModelProperty(value = "版式(详见上面wiki)")
  public String getTemplate() {
    return template;
  }

  public void setTemplate(String template) {
    this.template = template;
  }

  @JsonIgnore
  public CustomPrintControl customPrintInfo (Map<String, String> customPrintInfo) {
    this.customPrintInfo = customPrintInfo;
    return this;
  }

  public CustomPrintControl putCustomPrintInfoItem(String key, String customPrintInfoItem) {
    this.customPrintInfo.put(key, customPrintInfoItem);
    return this;
  }

   /**
   * 订制打印内容(详见上面wiki)
   * @return customPrintInfo
  **/
  @ApiModelProperty(value = "订制打印内容(详见上面wiki)")
  public Map<String, String> getCustomPrintInfo() {
    return customPrintInfo;
  }

  public void setCustomPrintInfo(Map<String, String> customPrintInfo) {
    this.customPrintInfo = customPrintInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CustomPrintControl customPrintControl = (CustomPrintControl) o;
    return Objects.equals(this.template, customPrintControl.template) &&
        Objects.equals(this.customPrintInfo, customPrintControl.customPrintInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(template, customPrintInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CustomPrintControl {\n");
    
    sb.append("    template: ").append(toIndentedString(template)).append("\n");
    sb.append("    customPrintInfo: ").append(toIndentedString(customPrintInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
