package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforcecloud.open.client.model.InvoicePrintInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * CustomPrintRequest
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class CustomPrintRequest {
  @JsonProperty("serialNo")
  private String serialNo = null;

  @JsonProperty("invoice")
  private InvoicePrintInfo invoice = null;

  @JsonIgnore
  public CustomPrintRequest serialNo (String serialNo) {
    this.serialNo = serialNo;
    return this;
  }

   /**
   * 请求流水号
   * @return serialNo
  **/
  @ApiModelProperty(value = "请求流水号")
  public String getSerialNo() {
    return serialNo;
  }

  public void setSerialNo(String serialNo) {
    this.serialNo = serialNo;
  }

  @JsonIgnore
  public CustomPrintRequest invoice (InvoicePrintInfo invoice) {
    this.invoice = invoice;
    return this;
  }

   /**
   * 发票主体信息
   * @return invoice
  **/
  @ApiModelProperty(value = "发票主体信息")
  public InvoicePrintInfo getInvoice() {
    return invoice;
  }

  public void setInvoice(InvoicePrintInfo invoice) {
    this.invoice = invoice;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CustomPrintRequest customPrintRequest = (CustomPrintRequest) o;
    return Objects.equals(this.serialNo, customPrintRequest.serialNo) &&
        Objects.equals(this.invoice, customPrintRequest.invoice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(serialNo, invoice);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CustomPrintRequest {\n");
    
    sb.append("    serialNo: ").append(toIndentedString(serialNo)).append("\n");
    sb.append("    invoice: ").append(toIndentedString(invoice)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
