package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 折扣信息
 */
@ApiModel(description = "折扣信息")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class DiscountInfo {
  @JsonProperty("discountWithoutTax")
  private BigDecimal discountWithoutTax = null;

  @JsonProperty("discountTax")
  private BigDecimal discountTax = null;

  @JsonIgnore
  public DiscountInfo discountWithoutTax (BigDecimal discountWithoutTax) {
    this.discountWithoutTax = discountWithoutTax;
    return this;
  }

   /**
   * 不含税折扣额
   * @return discountWithoutTax
  **/
  @ApiModelProperty(value = "不含税折扣额")
  public BigDecimal getDiscountWithoutTax() {
    return discountWithoutTax;
  }

  public void setDiscountWithoutTax(BigDecimal discountWithoutTax) {
    this.discountWithoutTax = discountWithoutTax;
  }

  @JsonIgnore
  public DiscountInfo discountTax (BigDecimal discountTax) {
    this.discountTax = discountTax;
    return this;
  }

   /**
   * 折扣税额
   * @return discountTax
  **/
  @ApiModelProperty(value = "折扣税额")
  public BigDecimal getDiscountTax() {
    return discountTax;
  }

  public void setDiscountTax(BigDecimal discountTax) {
    this.discountTax = discountTax;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DiscountInfo discountInfo = (DiscountInfo) o;
    return Objects.equals(this.discountWithoutTax, discountInfo.discountWithoutTax) &&
        Objects.equals(this.discountTax, discountInfo.discountTax);
  }

  @Override
  public int hashCode() {
    return Objects.hash(discountWithoutTax, discountTax);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DiscountInfo {\n");
    
    sb.append("    discountWithoutTax: ").append(toIndentedString(discountWithoutTax)).append("\n");
    sb.append("    discountTax: ").append(toIndentedString(discountTax)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
