package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforcecloud.open.client.model.GeneralBatchRequestTasks;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 批量生成任务请求
 */
@ApiModel(description = "批量生成任务请求")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class GeneralBatchRequest {
  @JsonProperty("group")
  private String group = null;

  @JsonProperty("callbackUrl")
  private String callbackUrl = null;

  @JsonProperty("tasks")
  private List<GeneralBatchRequestTasks> tasks = new ArrayList<GeneralBatchRequestTasks>();

  @JsonIgnore
  public GeneralBatchRequest group (String group) {
    this.group = group;
    return this;
  }

   /**
   * Get group
   * @return group
  **/
  @ApiModelProperty(value = "")
  public String getGroup() {
    return group;
  }

  public void setGroup(String group) {
    this.group = group;
  }

  @JsonIgnore
  public GeneralBatchRequest callbackUrl (String callbackUrl) {
    this.callbackUrl = callbackUrl;
    return this;
  }

   /**
   * Get callbackUrl
   * @return callbackUrl
  **/
  @ApiModelProperty(value = "")
  public String getCallbackUrl() {
    return callbackUrl;
  }

  public void setCallbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
  }

  @JsonIgnore
  public GeneralBatchRequest tasks (List<GeneralBatchRequestTasks> tasks) {
    this.tasks = tasks;
    return this;
  }

  public GeneralBatchRequest addTasksItem(GeneralBatchRequestTasks tasksItem) {
    this.tasks.add(tasksItem);
    return this;
  }

   /**
   * Get tasks
   * @return tasks
  **/
  @ApiModelProperty(value = "")
  public List<GeneralBatchRequestTasks> getTasks() {
    return tasks;
  }

  public void setTasks(List<GeneralBatchRequestTasks> tasks) {
    this.tasks = tasks;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeneralBatchRequest generalBatchRequest = (GeneralBatchRequest) o;
    return Objects.equals(this.group, generalBatchRequest.group) &&
        Objects.equals(this.callbackUrl, generalBatchRequest.callbackUrl) &&
        Objects.equals(this.tasks, generalBatchRequest.tasks);
  }

  @Override
  public int hashCode() {
    return Objects.hash(group, callbackUrl, tasks);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeneralBatchRequest {\n");
    
    sb.append("    group: ").append(toIndentedString(group)).append("\n");
    sb.append("    callbackUrl: ").append(toIndentedString(callbackUrl)).append("\n");
    sb.append("    tasks: ").append(toIndentedString(tasks)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
