package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * InvalidInvoiceRequest
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class InvalidInvoiceRequest {
  @JsonProperty("serialNo")
  private String serialNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invalidName")
  private String invalidName = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonIgnore
  public InvalidInvoiceRequest serialNo (String serialNo) {
    this.serialNo = serialNo;
    return this;
  }

   /**
   * 序列号
   * @return serialNo
  **/
  @ApiModelProperty(required = true, value = "序列号")
  public String getSerialNo() {
    return serialNo;
  }

  public void setSerialNo(String serialNo) {
    this.serialNo = serialNo;
  }

  @JsonIgnore
  public InvalidInvoiceRequest invoiceCode (String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(required = true, value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public InvalidInvoiceRequest invoiceNo (String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(required = true, value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public InvalidInvoiceRequest invalidName (String invalidName) {
    this.invalidName = invalidName;
    return this;
  }

   /**
   * 作废人姓名
   * @return invalidName
  **/
  @ApiModelProperty(required = true, value = "作废人姓名")
  public String getInvalidName() {
    return invalidName;
  }

  public void setInvalidName(String invalidName) {
    this.invalidName = invalidName;
  }

  @JsonIgnore
  public InvalidInvoiceRequest amountWithoutTax (BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(required = true, value = "不含税金额")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvalidInvoiceRequest invalidInvoiceRequest = (InvalidInvoiceRequest) o;
    return Objects.equals(this.serialNo, invalidInvoiceRequest.serialNo) &&
        Objects.equals(this.invoiceCode, invalidInvoiceRequest.invoiceCode) &&
        Objects.equals(this.invoiceNo, invalidInvoiceRequest.invoiceNo) &&
        Objects.equals(this.invalidName, invalidInvoiceRequest.invalidName) &&
        Objects.equals(this.amountWithoutTax, invalidInvoiceRequest.amountWithoutTax);
  }

  @Override
  public int hashCode() {
    return Objects.hash(serialNo, invoiceCode, invoiceNo, invalidName, amountWithoutTax);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvalidInvoiceRequest {\n");
    
    sb.append("    serialNo: ").append(toIndentedString(serialNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invalidName: ").append(toIndentedString(invalidName)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
