package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforcecloud.open.client.model.CustomPrintControl;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 发票开具控制项
 */
@ApiModel(description = "发票开具控制项")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class InvoiceControlInfo {
  @JsonProperty("displayPriceQuantity")
  private Boolean displayPriceQuantity = true;

  @JsonProperty("customPrintControl")
  private CustomPrintControl customPrintControl = null;

  @JsonIgnore
  public InvoiceControlInfo displayPriceQuantity (Boolean displayPriceQuantity) {
    this.displayPriceQuantity = displayPriceQuantity;
    return this;
  }

   /**
   * 是否显示单价和数量（诸如服务费类型的发票，只显示金额，没有单价和数量）。此标志为false时，会忽略明细中的单价和数量，默认值为true
   * @return displayPriceQuantity
  **/
  @ApiModelProperty(value = "是否显示单价和数量（诸如服务费类型的发票，只显示金额，没有单价和数量）。此标志为false时，会忽略明细中的单价和数量，默认值为true")
  public Boolean getDisplayPriceQuantity() {
    return displayPriceQuantity;
  }

  public void setDisplayPriceQuantity(Boolean displayPriceQuantity) {
    this.displayPriceQuantity = displayPriceQuantity;
  }

  @JsonIgnore
  public InvoiceControlInfo customPrintControl (CustomPrintControl customPrintControl) {
    this.customPrintControl = customPrintControl;
    return this;
  }

   /**
   * 定制打印控制项
   * @return customPrintControl
  **/
  @ApiModelProperty(value = "定制打印控制项")
  public CustomPrintControl getCustomPrintControl() {
    return customPrintControl;
  }

  public void setCustomPrintControl(CustomPrintControl customPrintControl) {
    this.customPrintControl = customPrintControl;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceControlInfo invoiceControlInfo = (InvoiceControlInfo) o;
    return Objects.equals(this.displayPriceQuantity, invoiceControlInfo.displayPriceQuantity) &&
        Objects.equals(this.customPrintControl, invoiceControlInfo.customPrintControl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(displayPriceQuantity, customPrintControl);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceControlInfo {\n");
    
    sb.append("    displayPriceQuantity: ").append(toIndentedString(displayPriceQuantity)).append("\n");
    sb.append("    customPrintControl: ").append(toIndentedString(customPrintControl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
