package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 发票明细信息
 */
@ApiModel(description = "发票明细信息")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class InvoiceDetail {
  @JsonProperty("cargoName")
  private String cargoName = null;

  @JsonProperty("quantityUnit")
  private String quantityUnit = null;

  @JsonProperty("itemSpec")
  private String itemSpec = null;

  @JsonProperty("unitPrice")
  private BigDecimal unitPrice = null;

  @JsonProperty("quantity")
  private BigDecimal quantity = null;

  @JsonProperty("amount")
  private BigDecimal amount = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("taxPre")
  private Integer taxPre = null;

  @JsonProperty("taxPreCon")
  private String taxPreCon = null;

  @JsonProperty("zeroTax")
  private String zeroTax = null;

  @JsonIgnore
  public InvoiceDetail cargoName (String cargoName) {
    this.cargoName = cargoName;
    return this;
  }

   /**
   * 货物或应税劳务名称
   * @return cargoName
  **/
  @ApiModelProperty(value = "货物或应税劳务名称")
  public String getCargoName() {
    return cargoName;
  }

  public void setCargoName(String cargoName) {
    this.cargoName = cargoName;
  }

  @JsonIgnore
  public InvoiceDetail quantityUnit (String quantityUnit) {
    this.quantityUnit = quantityUnit;
    return this;
  }

   /**
   * 单位
   * @return quantityUnit
  **/
  @ApiModelProperty(value = "单位")
  public String getQuantityUnit() {
    return quantityUnit;
  }

  public void setQuantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
  }

  @JsonIgnore
  public InvoiceDetail itemSpec (String itemSpec) {
    this.itemSpec = itemSpec;
    return this;
  }

   /**
   * 规格型号
   * @return itemSpec
  **/
  @ApiModelProperty(value = "规格型号")
  public String getItemSpec() {
    return itemSpec;
  }

  public void setItemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
  }

  @JsonIgnore
  public InvoiceDetail unitPrice (BigDecimal unitPrice) {
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * 不含税单价(小数点保留最多8位)
   * @return unitPrice
  **/
  @ApiModelProperty(value = "不含税单价(小数点保留最多8位)")
  public BigDecimal getUnitPrice() {
    return unitPrice;
  }

  public void setUnitPrice(BigDecimal unitPrice) {
    this.unitPrice = unitPrice;
  }

  @JsonIgnore
  public InvoiceDetail quantity (BigDecimal quantity) {
    this.quantity = quantity;
    return this;
  }

   /**
   * 数量(小数点保留最多8位)
   * @return quantity
  **/
  @ApiModelProperty(value = "数量(小数点保留最多8位)")
  public BigDecimal getQuantity() {
    return quantity;
  }

  public void setQuantity(BigDecimal quantity) {
    this.quantity = quantity;
  }

  @JsonIgnore
  public InvoiceDetail amount (BigDecimal amount) {
    this.amount = amount;
    return this;
  }

   /**
   * 不含税金额(小数点保留最多2位)
   * @return amount
  **/
  @ApiModelProperty(value = "不含税金额(小数点保留最多2位)")
  public BigDecimal getAmount() {
    return amount;
  }

  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  @JsonIgnore
  public InvoiceDetail taxAmount (BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额(小数点保留最多2位)
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额(小数点保留最多2位)")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public InvoiceDetail taxRate (String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率(例如，16%传0.16)
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率(例如，16%传0.16)")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public InvoiceDetail taxPre (Integer taxPre) {
    this.taxPre = taxPre;
    return this;
  }

   /**
   * 是否享受税收优惠政策 (0-不享受, 1-享受)
   * @return taxPre
  **/
  @ApiModelProperty(value = "是否享受税收优惠政策 (0-不享受, 1-享受)")
  public Integer getTaxPre() {
    return taxPre;
  }

  public void setTaxPre(Integer taxPre) {
    this.taxPre = taxPre;
  }

  @JsonIgnore
  public InvoiceDetail taxPreCon (String taxPreCon) {
    this.taxPreCon = taxPreCon;
    return this;
  }

   /**
   * 享受税收优惠政策内容
   * @return taxPreCon
  **/
  @ApiModelProperty(value = "享受税收优惠政策内容")
  public String getTaxPreCon() {
    return taxPreCon;
  }

  public void setTaxPreCon(String taxPreCon) {
    this.taxPreCon = taxPreCon;
  }

  @JsonIgnore
  public InvoiceDetail zeroTax (String zeroTax) {
    this.zeroTax = zeroTax;
    return this;
  }

   /**
   * 零税率标志 (空-非0税率；0-出口退税 1-免税 2-不征税 3-普通0税率)
   * @return zeroTax
  **/
  @ApiModelProperty(value = "零税率标志 (空-非0税率；0-出口退税 1-免税 2-不征税 3-普通0税率)")
  public String getZeroTax() {
    return zeroTax;
  }

  public void setZeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceDetail invoiceDetail = (InvoiceDetail) o;
    return Objects.equals(this.cargoName, invoiceDetail.cargoName) &&
        Objects.equals(this.quantityUnit, invoiceDetail.quantityUnit) &&
        Objects.equals(this.itemSpec, invoiceDetail.itemSpec) &&
        Objects.equals(this.unitPrice, invoiceDetail.unitPrice) &&
        Objects.equals(this.quantity, invoiceDetail.quantity) &&
        Objects.equals(this.amount, invoiceDetail.amount) &&
        Objects.equals(this.taxAmount, invoiceDetail.taxAmount) &&
        Objects.equals(this.taxRate, invoiceDetail.taxRate) &&
        Objects.equals(this.taxPre, invoiceDetail.taxPre) &&
        Objects.equals(this.taxPreCon, invoiceDetail.taxPreCon) &&
        Objects.equals(this.zeroTax, invoiceDetail.zeroTax);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cargoName, quantityUnit, itemSpec, unitPrice, quantity, amount, taxAmount, taxRate, taxPre, taxPreCon, zeroTax);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceDetail {\n");
    
    sb.append("    cargoName: ").append(toIndentedString(cargoName)).append("\n");
    sb.append("    quantityUnit: ").append(toIndentedString(quantityUnit)).append("\n");
    sb.append("    itemSpec: ").append(toIndentedString(itemSpec)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    taxPre: ").append(toIndentedString(taxPre)).append("\n");
    sb.append("    taxPreCon: ").append(toIndentedString(taxPreCon)).append("\n");
    sb.append("    zeroTax: ").append(toIndentedString(zeroTax)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
