package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 金额信息
 */
@ApiModel(description = "金额信息")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class InvoiceDetailAmountInfo {
  @JsonProperty("unitPrice")
  private BigDecimal unitPrice = null;

  @JsonProperty("quantity")
  private BigDecimal quantity = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("taxDedunction")
  private BigDecimal taxDedunction = null;

  @JsonIgnore
  public InvoiceDetailAmountInfo unitPrice (BigDecimal unitPrice) {
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * 不含税单价（保留小数点后8位）
   * @return unitPrice
  **/
  @ApiModelProperty(value = "不含税单价（保留小数点后8位）")
  public BigDecimal getUnitPrice() {
    return unitPrice;
  }

  public void setUnitPrice(BigDecimal unitPrice) {
    this.unitPrice = unitPrice;
  }

  @JsonIgnore
  public InvoiceDetailAmountInfo quantity (BigDecimal quantity) {
    this.quantity = quantity;
    return this;
  }

   /**
   * 数量（保留小数点后8位）
   * @return quantity
  **/
  @ApiModelProperty(value = "数量（保留小数点后8位）")
  public BigDecimal getQuantity() {
    return quantity;
  }

  public void setQuantity(BigDecimal quantity) {
    this.quantity = quantity;
  }

  @JsonIgnore
  public InvoiceDetailAmountInfo amountWithoutTax (BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额（保留小数点后2位）
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额（保留小数点后2位）")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public InvoiceDetailAmountInfo taxAmount (BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额（保留小数点后2位）
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额（保留小数点后2位）")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public InvoiceDetailAmountInfo taxDedunction (BigDecimal taxDedunction) {
    this.taxDedunction = taxDedunction;
    return this;
  }

   /**
   * 扣除额(差额征税)（保留小数点后2位）
   * @return taxDedunction
  **/
  @ApiModelProperty(value = "扣除额(差额征税)（保留小数点后2位）")
  public BigDecimal getTaxDedunction() {
    return taxDedunction;
  }

  public void setTaxDedunction(BigDecimal taxDedunction) {
    this.taxDedunction = taxDedunction;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceDetailAmountInfo invoiceDetailAmountInfo = (InvoiceDetailAmountInfo) o;
    return Objects.equals(this.unitPrice, invoiceDetailAmountInfo.unitPrice) &&
        Objects.equals(this.quantity, invoiceDetailAmountInfo.quantity) &&
        Objects.equals(this.amountWithoutTax, invoiceDetailAmountInfo.amountWithoutTax) &&
        Objects.equals(this.taxAmount, invoiceDetailAmountInfo.taxAmount) &&
        Objects.equals(this.taxDedunction, invoiceDetailAmountInfo.taxDedunction);
  }

  @Override
  public int hashCode() {
    return Objects.hash(unitPrice, quantity, amountWithoutTax, taxAmount, taxDedunction);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceDetailAmountInfo {\n");
    
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    taxDedunction: ").append(toIndentedString(taxDedunction)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
