package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforcecloud.open.client.model.BlockChainPurchaserInfo;
import com.xforcecloud.open.client.model.InvoiceAmountInfo;
import com.xforcecloud.open.client.model.InvoiceDetail;
import com.xforcecloud.open.client.model.OperatorInfo;
import com.xforcecloud.open.client.model.SellerInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 发票信息(折扣明细拆分为2行并按顺序排列)
 */
@ApiModel(description = "发票信息(折扣明细拆分为2行并按顺序排列)")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class InvoiceInfo {
  @JsonProperty("operator")
  private OperatorInfo operator = null;

  @JsonProperty("purchaser")
  private BlockChainPurchaserInfo purchaser = null;

  @JsonProperty("seller")
  private SellerInfo seller = null;

  @JsonProperty("amountInfo")
  private InvoiceAmountInfo amountInfo = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("cipherText")
  private String cipherText = null;

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceDate")
  private String invoiceDate = null;

  @JsonProperty("details")
  private List<InvoiceDetail> details = new ArrayList<InvoiceDetail>();

  @JsonIgnore
  public InvoiceInfo operator (OperatorInfo operator) {
    this.operator = operator;
    return this;
  }

   /**
   * 经办人
   * @return operator
  **/
  @ApiModelProperty(value = "经办人")
  public OperatorInfo getOperator() {
    return operator;
  }

  public void setOperator(OperatorInfo operator) {
    this.operator = operator;
  }

  @JsonIgnore
  public InvoiceInfo purchaser (BlockChainPurchaserInfo purchaser) {
    this.purchaser = purchaser;
    return this;
  }

   /**
   * 购方信息
   * @return purchaser
  **/
  @ApiModelProperty(value = "购方信息")
  public BlockChainPurchaserInfo getPurchaser() {
    return purchaser;
  }

  public void setPurchaser(BlockChainPurchaserInfo purchaser) {
    this.purchaser = purchaser;
  }

  @JsonIgnore
  public InvoiceInfo seller (SellerInfo seller) {
    this.seller = seller;
    return this;
  }

   /**
   * 销方信息
   * @return seller
  **/
  @ApiModelProperty(value = "销方信息")
  public SellerInfo getSeller() {
    return seller;
  }

  public void setSeller(SellerInfo seller) {
    this.seller = seller;
  }

  @JsonIgnore
  public InvoiceInfo amountInfo (InvoiceAmountInfo amountInfo) {
    this.amountInfo = amountInfo;
    return this;
  }

   /**
   * 合计金额信息
   * @return amountInfo
  **/
  @ApiModelProperty(value = "合计金额信息")
  public InvoiceAmountInfo getAmountInfo() {
    return amountInfo;
  }

  public void setAmountInfo(InvoiceAmountInfo amountInfo) {
    this.amountInfo = amountInfo;
  }

  @JsonIgnore
  public InvoiceInfo remark (String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public InvoiceInfo cipherText (String cipherText) {
    this.cipherText = cipherText;
    return this;
  }

   /**
   * 发票密文
   * @return cipherText
  **/
  @ApiModelProperty(value = "发票密文")
  public String getCipherText() {
    return cipherText;
  }

  public void setCipherText(String cipherText) {
    this.cipherText = cipherText;
  }

  @JsonIgnore
  public InvoiceInfo checkCode (String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * 校验码
   * @return checkCode
  **/
  @ApiModelProperty(value = "校验码")
  public String getCheckCode() {
    return checkCode;
  }

  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }

  @JsonIgnore
  public InvoiceInfo invoiceNo (String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public InvoiceInfo invoiceCode (String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public InvoiceInfo invoiceDate (String invoiceDate) {
    this.invoiceDate = invoiceDate;
    return this;
  }

   /**
   * 开票日期(yyyyMMdd)
   * @return invoiceDate
  **/
  @ApiModelProperty(value = "开票日期(yyyyMMdd)")
  public String getInvoiceDate() {
    return invoiceDate;
  }

  public void setInvoiceDate(String invoiceDate) {
    this.invoiceDate = invoiceDate;
  }

  @JsonIgnore
  public InvoiceInfo details (List<InvoiceDetail> details) {
    this.details = details;
    return this;
  }

  public InvoiceInfo addDetailsItem(InvoiceDetail detailsItem) {
    this.details.add(detailsItem);
    return this;
  }

   /**
   * 发票明细
   * @return details
  **/
  @ApiModelProperty(value = "发票明细")
  public List<InvoiceDetail> getDetails() {
    return details;
  }

  public void setDetails(List<InvoiceDetail> details) {
    this.details = details;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceInfo invoiceInfo = (InvoiceInfo) o;
    return Objects.equals(this.operator, invoiceInfo.operator) &&
        Objects.equals(this.purchaser, invoiceInfo.purchaser) &&
        Objects.equals(this.seller, invoiceInfo.seller) &&
        Objects.equals(this.amountInfo, invoiceInfo.amountInfo) &&
        Objects.equals(this.remark, invoiceInfo.remark) &&
        Objects.equals(this.cipherText, invoiceInfo.cipherText) &&
        Objects.equals(this.checkCode, invoiceInfo.checkCode) &&
        Objects.equals(this.invoiceNo, invoiceInfo.invoiceNo) &&
        Objects.equals(this.invoiceCode, invoiceInfo.invoiceCode) &&
        Objects.equals(this.invoiceDate, invoiceInfo.invoiceDate) &&
        Objects.equals(this.details, invoiceInfo.details);
  }

  @Override
  public int hashCode() {
    return Objects.hash(operator, purchaser, seller, amountInfo, remark, cipherText, checkCode, invoiceNo, invoiceCode, invoiceDate, details);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceInfo {\n");
    
    sb.append("    operator: ").append(toIndentedString(operator)).append("\n");
    sb.append("    purchaser: ").append(toIndentedString(purchaser)).append("\n");
    sb.append("    seller: ").append(toIndentedString(seller)).append("\n");
    sb.append("    amountInfo: ").append(toIndentedString(amountInfo)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    cipherText: ").append(toIndentedString(cipherText)).append("\n");
    sb.append("    checkCode: ").append(toIndentedString(checkCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceDate: ").append(toIndentedString(invoiceDate)).append("\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
