package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforcecloud.open.client.model.CustomPrintControl;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 发票开具控制项
 */
@ApiModel(description = "发票开具控制项")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class InvoicePrintControl {
  @JsonProperty("saleListFileFlag")
  private Boolean saleListFileFlag = false;

  @JsonProperty("customPrintControl")
  private CustomPrintControl customPrintControl = null;

  @JsonIgnore
  public InvoicePrintControl saleListFileFlag (Boolean saleListFileFlag) {
    this.saleListFileFlag = saleListFileFlag;
    return this;
  }

   /**
   * 是否打印销货清单
   * @return saleListFileFlag
  **/
  @ApiModelProperty(value = "是否打印销货清单")
  public Boolean getSaleListFileFlag() {
    return saleListFileFlag;
  }

  public void setSaleListFileFlag(Boolean saleListFileFlag) {
    this.saleListFileFlag = saleListFileFlag;
  }

  @JsonIgnore
  public InvoicePrintControl customPrintControl (CustomPrintControl customPrintControl) {
    this.customPrintControl = customPrintControl;
    return this;
  }

   /**
   * 定制打印控制项
   * @return customPrintControl
  **/
  @ApiModelProperty(value = "定制打印控制项")
  public CustomPrintControl getCustomPrintControl() {
    return customPrintControl;
  }

  public void setCustomPrintControl(CustomPrintControl customPrintControl) {
    this.customPrintControl = customPrintControl;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoicePrintControl invoicePrintControl = (InvoicePrintControl) o;
    return Objects.equals(this.saleListFileFlag, invoicePrintControl.saleListFileFlag) &&
        Objects.equals(this.customPrintControl, invoicePrintControl.customPrintControl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(saleListFileFlag, customPrintControl);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoicePrintControl {\n");
    
    sb.append("    saleListFileFlag: ").append(toIndentedString(saleListFileFlag)).append("\n");
    sb.append("    customPrintControl: ").append(toIndentedString(customPrintControl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
