package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforcecloud.open.client.model.InvoiceAmountInfo;
import com.xforcecloud.open.client.model.InvoiceDetail;
import com.xforcecloud.open.client.model.InvoicePrintControl;
import com.xforcecloud.open.client.model.OperatorInfo;
import com.xforcecloud.open.client.model.PurchaserInfo;
import com.xforcecloud.open.client.model.SellerInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 发票信息(折扣明细拆分为2行并按顺序排列)
 */
@ApiModel(description = "发票信息(折扣明细拆分为2行并按顺序排列)")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class InvoicePrintInfo {
  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("operatorInfo")
  private OperatorInfo operatorInfo = null;

  @JsonProperty("purchaser")
  private PurchaserInfo purchaser = null;

  @JsonProperty("seller")
  private SellerInfo seller = null;

  @JsonProperty("control")
  private InvoicePrintControl control = null;

  @JsonProperty("amountInfo")
  private InvoiceAmountInfo amountInfo = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("cipherText")
  private String cipherText = null;

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("makeInvoiceSource")
  private String makeInvoiceSource = null;

  @JsonProperty("invoiceDate")
  private String invoiceDate = null;

  @JsonProperty("details")
  private List<InvoiceDetail> details = new ArrayList<InvoiceDetail>();

  @JsonIgnore
  public InvoicePrintInfo invoiceType (String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型(s-专票, c-普票)
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型(s-专票, c-普票)")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public InvoicePrintInfo operatorInfo (OperatorInfo operatorInfo) {
    this.operatorInfo = operatorInfo;
    return this;
  }

   /**
   * 经办人
   * @return operatorInfo
  **/
  @ApiModelProperty(value = "经办人")
  public OperatorInfo getOperatorInfo() {
    return operatorInfo;
  }

  public void setOperatorInfo(OperatorInfo operatorInfo) {
    this.operatorInfo = operatorInfo;
  }

  @JsonIgnore
  public InvoicePrintInfo purchaser (PurchaserInfo purchaser) {
    this.purchaser = purchaser;
    return this;
  }

   /**
   * 购方信息
   * @return purchaser
  **/
  @ApiModelProperty(value = "购方信息")
  public PurchaserInfo getPurchaser() {
    return purchaser;
  }

  public void setPurchaser(PurchaserInfo purchaser) {
    this.purchaser = purchaser;
  }

  @JsonIgnore
  public InvoicePrintInfo seller (SellerInfo seller) {
    this.seller = seller;
    return this;
  }

   /**
   * 销方信息
   * @return seller
  **/
  @ApiModelProperty(value = "销方信息")
  public SellerInfo getSeller() {
    return seller;
  }

  public void setSeller(SellerInfo seller) {
    this.seller = seller;
  }

  @JsonIgnore
  public InvoicePrintInfo control (InvoicePrintControl control) {
    this.control = control;
    return this;
  }

   /**
   * 发票控制项
   * @return control
  **/
  @ApiModelProperty(value = "发票控制项")
  public InvoicePrintControl getControl() {
    return control;
  }

  public void setControl(InvoicePrintControl control) {
    this.control = control;
  }

  @JsonIgnore
  public InvoicePrintInfo amountInfo (InvoiceAmountInfo amountInfo) {
    this.amountInfo = amountInfo;
    return this;
  }

   /**
   * 合计金额信息
   * @return amountInfo
  **/
  @ApiModelProperty(value = "合计金额信息")
  public InvoiceAmountInfo getAmountInfo() {
    return amountInfo;
  }

  public void setAmountInfo(InvoiceAmountInfo amountInfo) {
    this.amountInfo = amountInfo;
  }

  @JsonIgnore
  public InvoicePrintInfo remark (String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public InvoicePrintInfo cipherText (String cipherText) {
    this.cipherText = cipherText;
    return this;
  }

   /**
   * 发票密文
   * @return cipherText
  **/
  @ApiModelProperty(value = "发票密文")
  public String getCipherText() {
    return cipherText;
  }

  public void setCipherText(String cipherText) {
    this.cipherText = cipherText;
  }

  @JsonIgnore
  public InvoicePrintInfo checkCode (String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * 校验码
   * @return checkCode
  **/
  @ApiModelProperty(value = "校验码")
  public String getCheckCode() {
    return checkCode;
  }

  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }

  @JsonIgnore
  public InvoicePrintInfo machineCode (String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 机器码
   * @return machineCode
  **/
  @ApiModelProperty(value = "机器码")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public InvoicePrintInfo invoiceNo (String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public InvoicePrintInfo invoiceCode (String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public InvoicePrintInfo makeInvoiceSource (String makeInvoiceSource) {
    this.makeInvoiceSource = makeInvoiceSource;
    return this;
  }

   /**
   * 发票开具来源：1-百望 2-航信
   * @return makeInvoiceSource
  **/
  @ApiModelProperty(value = "发票开具来源：1-百望 2-航信")
  public String getMakeInvoiceSource() {
    return makeInvoiceSource;
  }

  public void setMakeInvoiceSource(String makeInvoiceSource) {
    this.makeInvoiceSource = makeInvoiceSource;
  }

  @JsonIgnore
  public InvoicePrintInfo invoiceDate (String invoiceDate) {
    this.invoiceDate = invoiceDate;
    return this;
  }

   /**
   * 开票日期(yyyyMMdd)
   * @return invoiceDate
  **/
  @ApiModelProperty(value = "开票日期(yyyyMMdd)")
  public String getInvoiceDate() {
    return invoiceDate;
  }

  public void setInvoiceDate(String invoiceDate) {
    this.invoiceDate = invoiceDate;
  }

  @JsonIgnore
  public InvoicePrintInfo details (List<InvoiceDetail> details) {
    this.details = details;
    return this;
  }

  public InvoicePrintInfo addDetailsItem(InvoiceDetail detailsItem) {
    this.details.add(detailsItem);
    return this;
  }

   /**
   * 发票明细
   * @return details
  **/
  @ApiModelProperty(value = "发票明细")
  public List<InvoiceDetail> getDetails() {
    return details;
  }

  public void setDetails(List<InvoiceDetail> details) {
    this.details = details;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoicePrintInfo invoicePrintInfo = (InvoicePrintInfo) o;
    return Objects.equals(this.invoiceType, invoicePrintInfo.invoiceType) &&
        Objects.equals(this.operatorInfo, invoicePrintInfo.operatorInfo) &&
        Objects.equals(this.purchaser, invoicePrintInfo.purchaser) &&
        Objects.equals(this.seller, invoicePrintInfo.seller) &&
        Objects.equals(this.control, invoicePrintInfo.control) &&
        Objects.equals(this.amountInfo, invoicePrintInfo.amountInfo) &&
        Objects.equals(this.remark, invoicePrintInfo.remark) &&
        Objects.equals(this.cipherText, invoicePrintInfo.cipherText) &&
        Objects.equals(this.checkCode, invoicePrintInfo.checkCode) &&
        Objects.equals(this.machineCode, invoicePrintInfo.machineCode) &&
        Objects.equals(this.invoiceNo, invoicePrintInfo.invoiceNo) &&
        Objects.equals(this.invoiceCode, invoicePrintInfo.invoiceCode) &&
        Objects.equals(this.makeInvoiceSource, invoicePrintInfo.makeInvoiceSource) &&
        Objects.equals(this.invoiceDate, invoicePrintInfo.invoiceDate) &&
        Objects.equals(this.details, invoicePrintInfo.details);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceType, operatorInfo, purchaser, seller, control, amountInfo, remark, cipherText, checkCode, machineCode, invoiceNo, invoiceCode, makeInvoiceSource, invoiceDate, details);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoicePrintInfo {\n");
    
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    operatorInfo: ").append(toIndentedString(operatorInfo)).append("\n");
    sb.append("    purchaser: ").append(toIndentedString(purchaser)).append("\n");
    sb.append("    seller: ").append(toIndentedString(seller)).append("\n");
    sb.append("    control: ").append(toIndentedString(control)).append("\n");
    sb.append("    amountInfo: ").append(toIndentedString(amountInfo)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    cipherText: ").append(toIndentedString(cipherText)).append("\n");
    sb.append("    checkCode: ").append(toIndentedString(checkCode)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    makeInvoiceSource: ").append(toIndentedString(makeInvoiceSource)).append("\n");
    sb.append("    invoiceDate: ").append(toIndentedString(invoiceDate)).append("\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
