package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 发票明细信息
 */
@ApiModel(description = "发票明细信息")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class InvoicePrintResult {
  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("processFlag")
  private String processFlag = null;

  @JsonProperty("processRemark")
  private String processRemark = null;

  @JsonIgnore
  public InvoicePrintResult invoiceCode (String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public InvoicePrintResult invoiceNo (String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public InvoicePrintResult processFlag (String processFlag) {
    this.processFlag = processFlag;
    return this;
  }

   /**
   * 处理标记(1:打印成功)
   * @return processFlag
  **/
  @ApiModelProperty(value = "处理标记(1:打印成功)")
  public String getProcessFlag() {
    return processFlag;
  }

  public void setProcessFlag(String processFlag) {
    this.processFlag = processFlag;
  }

  @JsonIgnore
  public InvoicePrintResult processRemark (String processRemark) {
    this.processRemark = processRemark;
    return this;
  }

   /**
   * 处理信息描述
   * @return processRemark
  **/
  @ApiModelProperty(value = "处理信息描述")
  public String getProcessRemark() {
    return processRemark;
  }

  public void setProcessRemark(String processRemark) {
    this.processRemark = processRemark;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoicePrintResult invoicePrintResult = (InvoicePrintResult) o;
    return Objects.equals(this.invoiceCode, invoicePrintResult.invoiceCode) &&
        Objects.equals(this.invoiceNo, invoicePrintResult.invoiceNo) &&
        Objects.equals(this.processFlag, invoicePrintResult.processFlag) &&
        Objects.equals(this.processRemark, invoicePrintResult.processRemark);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceCode, invoiceNo, processFlag, processRemark);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoicePrintResult {\n");
    
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    processFlag: ").append(toIndentedString(processFlag)).append("\n");
    sb.append("    processRemark: ").append(toIndentedString(processRemark)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
