package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforcecloud.open.client.model.InvoiceAmountInfo;
import com.xforcecloud.open.client.model.InvoiceDetailInfo;
import com.xforcecloud.open.client.model.Operator;
import com.xforcecloud.open.client.model.PurchaserInfo;
import com.xforcecloud.open.client.model.RedInfo;
import com.xforcecloud.open.client.model.SellerInfo;
import com.xforcecloud.open.client.model.StatusInfo;
import com.xforcecloud.open.client.model.VehicleInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 发票开具信息
 */
@ApiModel(description = "发票开具信息")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class Invoices {
  @JsonProperty("pid")
  private String pid = null;

  @JsonProperty("statusInfo")
  private StatusInfo statusInfo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("cipherText")
  private String cipherText = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("invoiceDate")
  private String invoiceDate = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("operator")
  private Operator operator = null;

  @JsonProperty("purchaser")
  private PurchaserInfo purchaser = null;

  @JsonProperty("seller")
  private SellerInfo seller = null;

  @JsonProperty("redInfo")
  private RedInfo redInfo = null;

  @JsonProperty("vehicleInfo")
  private VehicleInfo vehicleInfo = null;

  @JsonProperty("amountInfo")
  private InvoiceAmountInfo amountInfo = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("details")
  private List<InvoiceDetailInfo> details = new ArrayList<InvoiceDetailInfo>();

  @JsonIgnore
  public Invoices pid (String pid) {
    this.pid = pid;
    return this;
  }

   /**
   * 预制发票ID
   * @return pid
  **/
  @ApiModelProperty(value = "预制发票ID")
  public String getPid() {
    return pid;
  }

  public void setPid(String pid) {
    this.pid = pid;
  }

  @JsonIgnore
  public Invoices statusInfo (StatusInfo statusInfo) {
    this.statusInfo = statusInfo;
    return this;
  }

   /**
   * 发票开具结果状态
   * @return statusInfo
  **/
  @ApiModelProperty(value = "发票开具结果状态")
  public StatusInfo getStatusInfo() {
    return statusInfo;
  }

  public void setStatusInfo(StatusInfo statusInfo) {
    this.statusInfo = statusInfo;
  }

  @JsonIgnore
  public Invoices invoiceCode (String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public Invoices invoiceNo (String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public Invoices checkCode (String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * 校验码
   * @return checkCode
  **/
  @ApiModelProperty(value = "校验码")
  public String getCheckCode() {
    return checkCode;
  }

  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }

  @JsonIgnore
  public Invoices cipherText (String cipherText) {
    this.cipherText = cipherText;
    return this;
  }

   /**
   * 密文
   * @return cipherText
  **/
  @ApiModelProperty(value = "密文")
  public String getCipherText() {
    return cipherText;
  }

  public void setCipherText(String cipherText) {
    this.cipherText = cipherText;
  }

  @JsonIgnore
  public Invoices machineCode (String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 机器码
   * @return machineCode
  **/
  @ApiModelProperty(value = "机器码")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public Invoices invoiceDate (String invoiceDate) {
    this.invoiceDate = invoiceDate;
    return this;
  }

   /**
   * 开票日期(yyyyMMdd)
   * @return invoiceDate
  **/
  @ApiModelProperty(value = "开票日期(yyyyMMdd)")
  public String getInvoiceDate() {
    return invoiceDate;
  }

  public void setInvoiceDate(String invoiceDate) {
    this.invoiceDate = invoiceDate;
  }

  @JsonIgnore
  public Invoices invoiceType (String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型(s-专票, c-普票, ju-卷票, v-机动车票, ce-电票)
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型(s-专票, c-普票, ju-卷票, v-机动车票, ce-电票)")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public Invoices operator (Operator operator) {
    this.operator = operator;
    return this;
  }

   /**
   * 经办人
   * @return operator
  **/
  @ApiModelProperty(value = "经办人")
  public Operator getOperator() {
    return operator;
  }

  public void setOperator(Operator operator) {
    this.operator = operator;
  }

  @JsonIgnore
  public Invoices purchaser (PurchaserInfo purchaser) {
    this.purchaser = purchaser;
    return this;
  }

   /**
   * 购方信息
   * @return purchaser
  **/
  @ApiModelProperty(value = "购方信息")
  public PurchaserInfo getPurchaser() {
    return purchaser;
  }

  public void setPurchaser(PurchaserInfo purchaser) {
    this.purchaser = purchaser;
  }

  @JsonIgnore
  public Invoices seller (SellerInfo seller) {
    this.seller = seller;
    return this;
  }

   /**
   * 销方信息
   * @return seller
  **/
  @ApiModelProperty(value = "销方信息")
  public SellerInfo getSeller() {
    return seller;
  }

  public void setSeller(SellerInfo seller) {
    this.seller = seller;
  }

  @JsonIgnore
  public Invoices redInfo (RedInfo redInfo) {
    this.redInfo = redInfo;
    return this;
  }

   /**
   * 发票红冲信息(用于开具红字发票)
   * @return redInfo
  **/
  @ApiModelProperty(value = "发票红冲信息(用于开具红字发票)")
  public RedInfo getRedInfo() {
    return redInfo;
  }

  public void setRedInfo(RedInfo redInfo) {
    this.redInfo = redInfo;
  }

  @JsonIgnore
  public Invoices vehicleInfo (VehicleInfo vehicleInfo) {
    this.vehicleInfo = vehicleInfo;
    return this;
  }

   /**
   * 机动车信息(用于开具机动车发票)
   * @return vehicleInfo
  **/
  @ApiModelProperty(value = "机动车信息(用于开具机动车发票)")
  public VehicleInfo getVehicleInfo() {
    return vehicleInfo;
  }

  public void setVehicleInfo(VehicleInfo vehicleInfo) {
    this.vehicleInfo = vehicleInfo;
  }

  @JsonIgnore
  public Invoices amountInfo (InvoiceAmountInfo amountInfo) {
    this.amountInfo = amountInfo;
    return this;
  }

   /**
   * 合计金额信息
   * @return amountInfo
  **/
  @ApiModelProperty(value = "合计金额信息")
  public InvoiceAmountInfo getAmountInfo() {
    return amountInfo;
  }

  public void setAmountInfo(InvoiceAmountInfo amountInfo) {
    this.amountInfo = amountInfo;
  }

  @JsonIgnore
  public Invoices remark (String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public Invoices details (List<InvoiceDetailInfo> details) {
    this.details = details;
    return this;
  }

  public Invoices addDetailsItem(InvoiceDetailInfo detailsItem) {
    this.details.add(detailsItem);
    return this;
  }

   /**
   * 发票明细
   * @return details
  **/
  @ApiModelProperty(value = "发票明细")
  public List<InvoiceDetailInfo> getDetails() {
    return details;
  }

  public void setDetails(List<InvoiceDetailInfo> details) {
    this.details = details;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Invoices invoices = (Invoices) o;
    return Objects.equals(this.pid, invoices.pid) &&
        Objects.equals(this.statusInfo, invoices.statusInfo) &&
        Objects.equals(this.invoiceCode, invoices.invoiceCode) &&
        Objects.equals(this.invoiceNo, invoices.invoiceNo) &&
        Objects.equals(this.checkCode, invoices.checkCode) &&
        Objects.equals(this.cipherText, invoices.cipherText) &&
        Objects.equals(this.machineCode, invoices.machineCode) &&
        Objects.equals(this.invoiceDate, invoices.invoiceDate) &&
        Objects.equals(this.invoiceType, invoices.invoiceType) &&
        Objects.equals(this.operator, invoices.operator) &&
        Objects.equals(this.purchaser, invoices.purchaser) &&
        Objects.equals(this.seller, invoices.seller) &&
        Objects.equals(this.redInfo, invoices.redInfo) &&
        Objects.equals(this.vehicleInfo, invoices.vehicleInfo) &&
        Objects.equals(this.amountInfo, invoices.amountInfo) &&
        Objects.equals(this.remark, invoices.remark) &&
        Objects.equals(this.details, invoices.details);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pid, statusInfo, invoiceCode, invoiceNo, checkCode, cipherText, machineCode, invoiceDate, invoiceType, operator, purchaser, seller, redInfo, vehicleInfo, amountInfo, remark, details);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Invoices {\n");
    
    sb.append("    pid: ").append(toIndentedString(pid)).append("\n");
    sb.append("    statusInfo: ").append(toIndentedString(statusInfo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    checkCode: ").append(toIndentedString(checkCode)).append("\n");
    sb.append("    cipherText: ").append(toIndentedString(cipherText)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    invoiceDate: ").append(toIndentedString(invoiceDate)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    operator: ").append(toIndentedString(operator)).append("\n");
    sb.append("    purchaser: ").append(toIndentedString(purchaser)).append("\n");
    sb.append("    seller: ").append(toIndentedString(seller)).append("\n");
    sb.append("    redInfo: ").append(toIndentedString(redInfo)).append("\n");
    sb.append("    vehicleInfo: ").append(toIndentedString(vehicleInfo)).append("\n");
    sb.append("    amountInfo: ").append(toIndentedString(amountInfo)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
