package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * InvoicesDeviceRequest
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class InvoicesDeviceRequest {
  @JsonProperty("serialNo")
  private String serialNo = null;

  @JsonProperty("terminalId")
  private Long terminalId = null;

  @JsonProperty("deviceId")
  private Long deviceId = null;

  @JsonIgnore
  public InvoicesDeviceRequest serialNo (String serialNo) {
    this.serialNo = serialNo;
    return this;
  }

   /**
   * 请求流水号
   * @return serialNo
  **/
  @ApiModelProperty(value = "请求流水号")
  public String getSerialNo() {
    return serialNo;
  }

  public void setSerialNo(String serialNo) {
    this.serialNo = serialNo;
  }

  @JsonIgnore
  public InvoicesDeviceRequest terminalId (Long terminalId) {
    this.terminalId = terminalId;
    return this;
  }

   /**
   * 终端ID (PC终端，必传)
   * @return terminalId
  **/
  @ApiModelProperty(value = "终端ID (PC终端，必传)")
  public Long getTerminalId() {
    return terminalId;
  }

  public void setTerminalId(Long terminalId) {
    this.terminalId = terminalId;
  }

  @JsonIgnore
  public InvoicesDeviceRequest deviceId (Long deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * 设备ID (税控设备，必传)
   * @return deviceId
  **/
  @ApiModelProperty(value = "设备ID (税控设备，必传)")
  public Long getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(Long deviceId) {
    this.deviceId = deviceId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoicesDeviceRequest invoicesDeviceRequest = (InvoicesDeviceRequest) o;
    return Objects.equals(this.serialNo, invoicesDeviceRequest.serialNo) &&
        Objects.equals(this.terminalId, invoicesDeviceRequest.terminalId) &&
        Objects.equals(this.deviceId, invoicesDeviceRequest.deviceId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(serialNo, terminalId, deviceId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoicesDeviceRequest {\n");
    
    sb.append("    serialNo: ").append(toIndentedString(serialNo)).append("\n");
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
