package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforcecloud.open.client.model.PrintInvoices;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * InvoicesPrintRequest
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class InvoicesPrintRequest {
  @JsonProperty("serialNo")
  private String serialNo = null;

  @JsonProperty("groupId")
  private String groupId = null;

  @JsonProperty("printType")
  private String printType = null;

  @JsonProperty("mode")
  private String mode = null;

  @JsonProperty("terminalId")
  private BigDecimal terminalId = null;

  @JsonProperty("deviceId")
  private BigDecimal deviceId = null;

  @JsonProperty("invoiceList")
  private List<PrintInvoices> invoiceList = new ArrayList<PrintInvoices>();

  @JsonIgnore
  public InvoicesPrintRequest serialNo (String serialNo) {
    this.serialNo = serialNo;
    return this;
  }

   /**
   * 请求流水号
   * @return serialNo
  **/
  @ApiModelProperty(value = "请求流水号")
  public String getSerialNo() {
    return serialNo;
  }

  public void setSerialNo(String serialNo) {
    this.serialNo = serialNo;
  }

  @JsonIgnore
  public InvoicesPrintRequest groupId (String groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团ID
   * @return groupId
  **/
  @ApiModelProperty(value = "集团ID")
  public String getGroupId() {
    return groupId;
  }

  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public InvoicesPrintRequest printType (String printType) {
    this.printType = printType;
    return this;
  }

   /**
   * 打印方式选择(general_print-通用打印<服务器开票只能用通用打印> taxplate_print-税盘（税控）打印 custom_print-订制打印<传全量发票信息>)
   * @return printType
  **/
  @ApiModelProperty(value = "打印方式选择(general_print-通用打印<服务器开票只能用通用打印> taxplate_print-税盘（税控）打印 custom_print-订制打印<传全量发票信息>)")
  public String getPrintType() {
    return printType;
  }

  public void setPrintType(String printType) {
    this.printType = printType;
  }

  @JsonIgnore
  public InvoicesPrintRequest mode (String mode) {
    this.mode = mode;
    return this;
  }

   /**
   * 打印类型（print_invoice-发票  print_salelist-销货清单）
   * @return mode
  **/
  @ApiModelProperty(value = "打印类型（print_invoice-发票  print_salelist-销货清单）")
  public String getMode() {
    return mode;
  }

  public void setMode(String mode) {
    this.mode = mode;
  }

  @JsonIgnore
  public InvoicesPrintRequest terminalId (BigDecimal terminalId) {
    this.terminalId = terminalId;
    return this;
  }

   /**
   * 开票终端ID
   * @return terminalId
  **/
  @ApiModelProperty(value = "开票终端ID")
  public BigDecimal getTerminalId() {
    return terminalId;
  }

  public void setTerminalId(BigDecimal terminalId) {
    this.terminalId = terminalId;
  }

  @JsonIgnore
  public InvoicesPrintRequest deviceId (BigDecimal deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * 设备ID
   * @return deviceId
  **/
  @ApiModelProperty(value = "设备ID")
  public BigDecimal getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(BigDecimal deviceId) {
    this.deviceId = deviceId;
  }

  @JsonIgnore
  public InvoicesPrintRequest invoiceList (List<PrintInvoices> invoiceList) {
    this.invoiceList = invoiceList;
    return this;
  }

  public InvoicesPrintRequest addInvoiceListItem(PrintInvoices invoiceListItem) {
    this.invoiceList.add(invoiceListItem);
    return this;
  }

   /**
   * 预制发票列表
   * @return invoiceList
  **/
  @ApiModelProperty(value = "预制发票列表")
  public List<PrintInvoices> getInvoiceList() {
    return invoiceList;
  }

  public void setInvoiceList(List<PrintInvoices> invoiceList) {
    this.invoiceList = invoiceList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoicesPrintRequest invoicesPrintRequest = (InvoicesPrintRequest) o;
    return Objects.equals(this.serialNo, invoicesPrintRequest.serialNo) &&
        Objects.equals(this.groupId, invoicesPrintRequest.groupId) &&
        Objects.equals(this.printType, invoicesPrintRequest.printType) &&
        Objects.equals(this.mode, invoicesPrintRequest.mode) &&
        Objects.equals(this.terminalId, invoicesPrintRequest.terminalId) &&
        Objects.equals(this.deviceId, invoicesPrintRequest.deviceId) &&
        Objects.equals(this.invoiceList, invoicesPrintRequest.invoiceList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(serialNo, groupId, printType, mode, terminalId, deviceId, invoiceList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoicesPrintRequest {\n");
    
    sb.append("    serialNo: ").append(toIndentedString(serialNo)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    printType: ").append(toIndentedString(printType)).append("\n");
    sb.append("    mode: ").append(toIndentedString(mode)).append("\n");
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    invoiceList: ").append(toIndentedString(invoiceList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
