package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforcecloud.open.client.model.InvoicePrintResult;
import com.xforcecloud.open.client.model.OutPutResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * InvoicesPrintResultResponse
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class InvoicesPrintResultResponse {
  @JsonProperty("head")
  private OutPutResponseHead head = null;

  @JsonProperty("invoices")
  private List<InvoicePrintResult> invoices = new ArrayList<InvoicePrintResult>();

  @JsonIgnore
  public InvoicesPrintResultResponse head (OutPutResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 销项公共头部 - 开具结果
   * @return head
  **/
  @ApiModelProperty(value = "销项公共头部 - 开具结果")
  public OutPutResponseHead getHead() {
    return head;
  }

  public void setHead(OutPutResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public InvoicesPrintResultResponse invoices (List<InvoicePrintResult> invoices) {
    this.invoices = invoices;
    return this;
  }

  public InvoicesPrintResultResponse addInvoicesItem(InvoicePrintResult invoicesItem) {
    this.invoices.add(invoicesItem);
    return this;
  }

   /**
   * 预制发票列表
   * @return invoices
  **/
  @ApiModelProperty(value = "预制发票列表")
  public List<InvoicePrintResult> getInvoices() {
    return invoices;
  }

  public void setInvoices(List<InvoicePrintResult> invoices) {
    this.invoices = invoices;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoicesPrintResultResponse invoicesPrintResultResponse = (InvoicesPrintResultResponse) o;
    return Objects.equals(this.head, invoicesPrintResultResponse.head) &&
        Objects.equals(this.invoices, invoicesPrintResultResponse.invoices);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, invoices);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoicesPrintResultResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    invoices: ").append(toIndentedString(invoices)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
