package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforcecloud.open.client.model.NextConfirm;
import com.xforcecloud.open.client.model.PreInvoiceInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * InvoicesRequest
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class InvoicesRequest {
  @JsonProperty("serialNo")
  private String serialNo = null;

  @JsonProperty("groupId")
  private String groupId = null;

  @JsonProperty("mode")
  private String mode = null;

  @JsonProperty("nextConfirm")
  private NextConfirm nextConfirm = null;

  @JsonProperty("terminalId")
  private BigDecimal terminalId = null;

  @JsonProperty("deviceId")
  private BigDecimal deviceId = null;

  @JsonProperty("preInvoiceList")
  private List<PreInvoiceInfo> preInvoiceList = new ArrayList<PreInvoiceInfo>();

  @JsonIgnore
  public InvoicesRequest serialNo (String serialNo) {
    this.serialNo = serialNo;
    return this;
  }

   /**
   * 请求流水号, GUID
   * @return serialNo
  **/
  @ApiModelProperty(required = true, value = "请求流水号, GUID")
  public String getSerialNo() {
    return serialNo;
  }

  public void setSerialNo(String serialNo) {
    this.serialNo = serialNo;
  }

  @JsonIgnore
  public InvoicesRequest groupId (String groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团ID
   * @return groupId
  **/
  @ApiModelProperty(required = true, value = "集团ID")
  public String getGroupId() {
    return groupId;
  }

  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public InvoicesRequest mode (String mode) {
    this.mode = mode;
    return this;
  }

   /**
   * 模式(issue-仅开具, issue_print-开具并打印)
   * @return mode
  **/
  @ApiModelProperty(required = true, value = "模式(issue-仅开具, issue_print-开具并打印)")
  public String getMode() {
    return mode;
  }

  public void setMode(String mode) {
    this.mode = mode;
  }

  @JsonIgnore
  public InvoicesRequest nextConfirm (NextConfirm nextConfirm) {
    this.nextConfirm = nextConfirm;
    return this;
  }

   /**
   * 下一发票号码确认（仅在mode选择开具并打印时，有作用）
   * @return nextConfirm
  **/
  @ApiModelProperty(required = true, value = "下一发票号码确认（仅在mode选择开具并打印时，有作用）")
  public NextConfirm getNextConfirm() {
    return nextConfirm;
  }

  public void setNextConfirm(NextConfirm nextConfirm) {
    this.nextConfirm = nextConfirm;
  }

  @JsonIgnore
  public InvoicesRequest terminalId (BigDecimal terminalId) {
    this.terminalId = terminalId;
    return this;
  }

   /**
   * 开票终端ID
   * @return terminalId
  **/
  @ApiModelProperty(required = true, value = "开票终端ID")
  public BigDecimal getTerminalId() {
    return terminalId;
  }

  public void setTerminalId(BigDecimal terminalId) {
    this.terminalId = terminalId;
  }

  @JsonIgnore
  public InvoicesRequest deviceId (BigDecimal deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * 设备ID
   * @return deviceId
  **/
  @ApiModelProperty(required = true, value = "设备ID")
  public BigDecimal getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(BigDecimal deviceId) {
    this.deviceId = deviceId;
  }

  @JsonIgnore
  public InvoicesRequest preInvoiceList (List<PreInvoiceInfo> preInvoiceList) {
    this.preInvoiceList = preInvoiceList;
    return this;
  }

  public InvoicesRequest addPreInvoiceListItem(PreInvoiceInfo preInvoiceListItem) {
    this.preInvoiceList.add(preInvoiceListItem);
    return this;
  }

   /**
   * 预制发票列表
   * @return preInvoiceList
  **/
  @ApiModelProperty(value = "预制发票列表")
  public List<PreInvoiceInfo> getPreInvoiceList() {
    return preInvoiceList;
  }

  public void setPreInvoiceList(List<PreInvoiceInfo> preInvoiceList) {
    this.preInvoiceList = preInvoiceList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoicesRequest invoicesRequest = (InvoicesRequest) o;
    return Objects.equals(this.serialNo, invoicesRequest.serialNo) &&
        Objects.equals(this.groupId, invoicesRequest.groupId) &&
        Objects.equals(this.mode, invoicesRequest.mode) &&
        Objects.equals(this.nextConfirm, invoicesRequest.nextConfirm) &&
        Objects.equals(this.terminalId, invoicesRequest.terminalId) &&
        Objects.equals(this.deviceId, invoicesRequest.deviceId) &&
        Objects.equals(this.preInvoiceList, invoicesRequest.preInvoiceList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(serialNo, groupId, mode, nextConfirm, terminalId, deviceId, preInvoiceList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoicesRequest {\n");
    
    sb.append("    serialNo: ").append(toIndentedString(serialNo)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    mode: ").append(toIndentedString(mode)).append("\n");
    sb.append("    nextConfirm: ").append(toIndentedString(nextConfirm)).append("\n");
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    preInvoiceList: ").append(toIndentedString(preInvoiceList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
