package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforcecloud.open.client.model.Invoices;
import com.xforcecloud.open.client.model.OutPutResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * InvoicesResultResponse
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class InvoicesResultResponse {
  @JsonProperty("head")
  private OutPutResponseHead head = null;

  @JsonProperty("serialNo")
  private String serialNo = null;

  @JsonProperty("invoices")
  private List<Invoices> invoices = new ArrayList<Invoices>();

  @JsonIgnore
  public InvoicesResultResponse head (OutPutResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 销项公共头部 - 开具结果
   * @return head
  **/
  @ApiModelProperty(value = "销项公共头部 - 开具结果")
  public OutPutResponseHead getHead() {
    return head;
  }

  public void setHead(OutPutResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public InvoicesResultResponse serialNo (String serialNo) {
    this.serialNo = serialNo;
    return this;
  }

   /**
   * 请求流水号
   * @return serialNo
  **/
  @ApiModelProperty(value = "请求流水号")
  public String getSerialNo() {
    return serialNo;
  }

  public void setSerialNo(String serialNo) {
    this.serialNo = serialNo;
  }

  @JsonIgnore
  public InvoicesResultResponse invoices (List<Invoices> invoices) {
    this.invoices = invoices;
    return this;
  }

  public InvoicesResultResponse addInvoicesItem(Invoices invoicesItem) {
    this.invoices.add(invoicesItem);
    return this;
  }

   /**
   * 预制发票列表
   * @return invoices
  **/
  @ApiModelProperty(value = "预制发票列表")
  public List<Invoices> getInvoices() {
    return invoices;
  }

  public void setInvoices(List<Invoices> invoices) {
    this.invoices = invoices;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoicesResultResponse invoicesResultResponse = (InvoicesResultResponse) o;
    return Objects.equals(this.head, invoicesResultResponse.head) &&
        Objects.equals(this.serialNo, invoicesResultResponse.serialNo) &&
        Objects.equals(this.invoices, invoicesResultResponse.invoices);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, serialNo, invoices);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoicesResultResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    serialNo: ").append(toIndentedString(serialNo)).append("\n");
    sb.append("    invoices: ").append(toIndentedString(invoices)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
