package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 下一发票号码确认（仅在mode选择开具并打印时，有作用）
 */
@ApiModel(description = "下一发票号码确认（仅在mode选择开具并打印时，有作用）")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class NextConfirm {
  @JsonProperty("confirmType")
  private String confirmType = null;

  @JsonProperty("nextInvoiceCode")
  private String nextInvoiceCode = null;

  @JsonProperty("nextInvoiceNo")
  private String nextInvoiceNo = null;

  @JsonIgnore
  public NextConfirm confirmType (String confirmType) {
    this.confirmType = confirmType;
    return this;
  }

   /**
   * 确认类型(front_confirm-前端页面确认，client_confirm-客户端弹框确认)
   * @return confirmType
  **/
  @ApiModelProperty(value = "确认类型(front_confirm-前端页面确认，client_confirm-客户端弹框确认)")
  public String getConfirmType() {
    return confirmType;
  }

  public void setConfirmType(String confirmType) {
    this.confirmType = confirmType;
  }

  @JsonIgnore
  public NextConfirm nextInvoiceCode (String nextInvoiceCode) {
    this.nextInvoiceCode = nextInvoiceCode;
    return this;
  }

   /**
   * 下一发票代码
   * @return nextInvoiceCode
  **/
  @ApiModelProperty(value = "下一发票代码")
  public String getNextInvoiceCode() {
    return nextInvoiceCode;
  }

  public void setNextInvoiceCode(String nextInvoiceCode) {
    this.nextInvoiceCode = nextInvoiceCode;
  }

  @JsonIgnore
  public NextConfirm nextInvoiceNo (String nextInvoiceNo) {
    this.nextInvoiceNo = nextInvoiceNo;
    return this;
  }

   /**
   * 下一发票号码
   * @return nextInvoiceNo
  **/
  @ApiModelProperty(value = "下一发票号码")
  public String getNextInvoiceNo() {
    return nextInvoiceNo;
  }

  public void setNextInvoiceNo(String nextInvoiceNo) {
    this.nextInvoiceNo = nextInvoiceNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NextConfirm nextConfirm = (NextConfirm) o;
    return Objects.equals(this.confirmType, nextConfirm.confirmType) &&
        Objects.equals(this.nextInvoiceCode, nextConfirm.nextInvoiceCode) &&
        Objects.equals(this.nextInvoiceNo, nextConfirm.nextInvoiceNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(confirmType, nextInvoiceCode, nextInvoiceNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NextConfirm {\n");
    
    sb.append("    confirmType: ").append(toIndentedString(confirmType)).append("\n");
    sb.append("    nextInvoiceCode: ").append(toIndentedString(nextInvoiceCode)).append("\n");
    sb.append("    nextInvoiceNo: ").append(toIndentedString(nextInvoiceNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
