package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * NextInvoiceNoRequest
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class NextInvoiceNoRequest {
  @JsonProperty("serialNo")
  private String serialNo = null;

  @JsonProperty("invoiceMainType")
  private String invoiceMainType = null;

  @JsonProperty("terminalId")
  private Long terminalId = null;

  @JsonProperty("deviceId")
  private Long deviceId = null;

  @JsonIgnore
  public NextInvoiceNoRequest serialNo (String serialNo) {
    this.serialNo = serialNo;
    return this;
  }

   /**
   * 请求序列号(获取下一张发票号码使用)
   * @return serialNo
  **/
  @ApiModelProperty(value = "请求序列号(获取下一张发票号码使用)")
  public String getSerialNo() {
    return serialNo;
  }

  public void setSerialNo(String serialNo) {
    this.serialNo = serialNo;
  }

  @JsonIgnore
  public NextInvoiceNoRequest invoiceMainType (String invoiceMainType) {
    this.invoiceMainType = invoiceMainType;
    return this;
  }

   /**
   * 发票类型
   * @return invoiceMainType
  **/
  @ApiModelProperty(value = "发票类型")
  public String getInvoiceMainType() {
    return invoiceMainType;
  }

  public void setInvoiceMainType(String invoiceMainType) {
    this.invoiceMainType = invoiceMainType;
  }

  @JsonIgnore
  public NextInvoiceNoRequest terminalId (Long terminalId) {
    this.terminalId = terminalId;
    return this;
  }

   /**
   * 终端ID (PC终端，必传)
   * @return terminalId
  **/
  @ApiModelProperty(value = "终端ID (PC终端，必传)")
  public Long getTerminalId() {
    return terminalId;
  }

  public void setTerminalId(Long terminalId) {
    this.terminalId = terminalId;
  }

  @JsonIgnore
  public NextInvoiceNoRequest deviceId (Long deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * 设备ID (税控设备，必传)
   * @return deviceId
  **/
  @ApiModelProperty(value = "设备ID (税控设备，必传)")
  public Long getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(Long deviceId) {
    this.deviceId = deviceId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NextInvoiceNoRequest nextInvoiceNoRequest = (NextInvoiceNoRequest) o;
    return Objects.equals(this.serialNo, nextInvoiceNoRequest.serialNo) &&
        Objects.equals(this.invoiceMainType, nextInvoiceNoRequest.invoiceMainType) &&
        Objects.equals(this.terminalId, nextInvoiceNoRequest.terminalId) &&
        Objects.equals(this.deviceId, nextInvoiceNoRequest.deviceId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(serialNo, invoiceMainType, terminalId, deviceId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NextInvoiceNoRequest {\n");
    
    sb.append("    serialNo: ").append(toIndentedString(serialNo)).append("\n");
    sb.append("    invoiceMainType: ").append(toIndentedString(invoiceMainType)).append("\n");
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
