package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 查询生成PDF结果
 */
@ApiModel(description = "查询生成PDF结果")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class NextInvoiceNoResult {
  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("serialNo")
  private String serialNo = null;

  @JsonProperty("tenantNo")
  private String tenantNo = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonIgnore
  public NextInvoiceNoResult invoiceNo (String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 下张发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "下张发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public NextInvoiceNoResult invoiceCode (String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 下张发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "下张发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public NextInvoiceNoResult serialNo (String serialNo) {
    this.serialNo = serialNo;
    return this;
  }

   /**
   * 请求时流水号
   * @return serialNo
  **/
  @ApiModelProperty(value = "请求时流水号")
  public String getSerialNo() {
    return serialNo;
  }

  public void setSerialNo(String serialNo) {
    this.serialNo = serialNo;
  }

  @JsonIgnore
  public NextInvoiceNoResult tenantNo (String tenantNo) {
    this.tenantNo = tenantNo;
    return this;
  }

   /**
   * 商户ID
   * @return tenantNo
  **/
  @ApiModelProperty(value = "商户ID")
  public String getTenantNo() {
    return tenantNo;
  }

  public void setTenantNo(String tenantNo) {
    this.tenantNo = tenantNo;
  }

  @JsonIgnore
  public NextInvoiceNoResult invoiceType (String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public NextInvoiceNoResult status (String status) {
    this.status = status;
    return this;
  }

   /**
   * 客户端返回状态
   * @return status
  **/
  @ApiModelProperty(value = "客户端返回状态")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  @JsonIgnore
  public NextInvoiceNoResult remark (String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 客户端返回标记
   * @return remark
  **/
  @ApiModelProperty(value = "客户端返回标记")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NextInvoiceNoResult nextInvoiceNoResult = (NextInvoiceNoResult) o;
    return Objects.equals(this.invoiceNo, nextInvoiceNoResult.invoiceNo) &&
        Objects.equals(this.invoiceCode, nextInvoiceNoResult.invoiceCode) &&
        Objects.equals(this.serialNo, nextInvoiceNoResult.serialNo) &&
        Objects.equals(this.tenantNo, nextInvoiceNoResult.tenantNo) &&
        Objects.equals(this.invoiceType, nextInvoiceNoResult.invoiceType) &&
        Objects.equals(this.status, nextInvoiceNoResult.status) &&
        Objects.equals(this.remark, nextInvoiceNoResult.remark);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceNo, invoiceCode, serialNo, tenantNo, invoiceType, status, remark);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NextInvoiceNoResult {\n");
    
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    serialNo: ").append(toIndentedString(serialNo)).append("\n");
    sb.append("    tenantNo: ").append(toIndentedString(tenantNo)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
