package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 经办人
 */
@ApiModel(description = "经办人")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class OperatorInfo {
  @JsonProperty("invoicerName")
  private String invoicerName = null;

  @JsonProperty("checkerName")
  private String checkerName = null;

  @JsonProperty("cashierName")
  private String cashierName = null;

  @JsonIgnore
  public OperatorInfo invoicerName (String invoicerName) {
    this.invoicerName = invoicerName;
    return this;
  }

   /**
   * 开票人
   * @return invoicerName
  **/
  @ApiModelProperty(value = "开票人")
  public String getInvoicerName() {
    return invoicerName;
  }

  public void setInvoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
  }

  @JsonIgnore
  public OperatorInfo checkerName (String checkerName) {
    this.checkerName = checkerName;
    return this;
  }

   /**
   * 复核人
   * @return checkerName
  **/
  @ApiModelProperty(value = "复核人")
  public String getCheckerName() {
    return checkerName;
  }

  public void setCheckerName(String checkerName) {
    this.checkerName = checkerName;
  }

  @JsonIgnore
  public OperatorInfo cashierName (String cashierName) {
    this.cashierName = cashierName;
    return this;
  }

   /**
   * 收款人
   * @return cashierName
  **/
  @ApiModelProperty(value = "收款人")
  public String getCashierName() {
    return cashierName;
  }

  public void setCashierName(String cashierName) {
    this.cashierName = cashierName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperatorInfo operatorInfo = (OperatorInfo) o;
    return Objects.equals(this.invoicerName, operatorInfo.invoicerName) &&
        Objects.equals(this.checkerName, operatorInfo.checkerName) &&
        Objects.equals(this.cashierName, operatorInfo.cashierName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoicerName, checkerName, cashierName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperatorInfo {\n");
    
    sb.append("    invoicerName: ").append(toIndentedString(invoicerName)).append("\n");
    sb.append("    checkerName: ").append(toIndentedString(checkerName)).append("\n");
    sb.append("    cashierName: ").append(toIndentedString(cashierName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
