package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 销项标准响应头
 */
@ApiModel(description = "销项标准响应头")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class OutPutResponseHead {
  @JsonProperty("message")
  private String message = null;

  @JsonProperty("traceId")
  private String traceId = null;

  @JsonIgnore
  public OutPutResponseHead message (String message) {
    this.message = message;
    return this;
  }

   /**
   * 信息(HTTP状态码不是2xx时，会有具体的业务报错信息)
   * @return message
  **/
  @ApiModelProperty(value = "信息(HTTP状态码不是2xx时，会有具体的业务报错信息)")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public OutPutResponseHead traceId (String traceId) {
    this.traceId = traceId;
    return this;
  }

   /**
   * 跟踪ID(服务提供用来排查业务问题时的线索)
   * @return traceId
  **/
  @ApiModelProperty(value = "跟踪ID(服务提供用来排查业务问题时的线索)")
  public String getTraceId() {
    return traceId;
  }

  public void setTraceId(String traceId) {
    this.traceId = traceId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OutPutResponseHead outPutResponseHead = (OutPutResponseHead) o;
    return Objects.equals(this.message, outPutResponseHead.message) &&
        Objects.equals(this.traceId, outPutResponseHead.traceId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(message, traceId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OutPutResponseHead {\n");
    
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    traceId: ").append(toIndentedString(traceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
