package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforcecloud.open.client.model.InvoiceAmountInfo;
import com.xforcecloud.open.client.model.InvoiceControlInfo;
import com.xforcecloud.open.client.model.InvoiceDetailInfo;
import com.xforcecloud.open.client.model.Operator;
import com.xforcecloud.open.client.model.PurchaserInfo;
import com.xforcecloud.open.client.model.RedInfo;
import com.xforcecloud.open.client.model.SellerInfo;
import com.xforcecloud.open.client.model.VehicleInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 发票开具信息
 */
@ApiModel(description = "发票开具信息")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class PreInvoiceInfo {
  @JsonProperty("pid")
  private String pid = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("operator")
  private Operator operator = null;

  @JsonProperty("purchaser")
  private PurchaserInfo purchaser = null;

  @JsonProperty("seller")
  private SellerInfo seller = null;

  @JsonProperty("control")
  private InvoiceControlInfo control = null;

  @JsonProperty("redInfo")
  private RedInfo redInfo = null;

  @JsonProperty("vehicleInfo")
  private VehicleInfo vehicleInfo = null;

  @JsonProperty("amountInfo")
  private InvoiceAmountInfo amountInfo = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("listGoodsName")
  private String listGoodsName = null;

  @JsonProperty("details")
  private List<InvoiceDetailInfo> details = new ArrayList<InvoiceDetailInfo>();

  @JsonIgnore
  public PreInvoiceInfo pid (String pid) {
    this.pid = pid;
    return this;
  }

   /**
   * 预制发票ID
   * @return pid
  **/
  @ApiModelProperty(value = "预制发票ID")
  public String getPid() {
    return pid;
  }

  public void setPid(String pid) {
    this.pid = pid;
  }

  @JsonIgnore
  public PreInvoiceInfo invoiceType (String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型(s-专票, c-普票, ju-卷票, v-机动车票, ce-电票)
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型(s-专票, c-普票, ju-卷票, v-机动车票, ce-电票)")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public PreInvoiceInfo operator (Operator operator) {
    this.operator = operator;
    return this;
  }

   /**
   * 经办人
   * @return operator
  **/
  @ApiModelProperty(value = "经办人")
  public Operator getOperator() {
    return operator;
  }

  public void setOperator(Operator operator) {
    this.operator = operator;
  }

  @JsonIgnore
  public PreInvoiceInfo purchaser (PurchaserInfo purchaser) {
    this.purchaser = purchaser;
    return this;
  }

   /**
   * 购方信息
   * @return purchaser
  **/
  @ApiModelProperty(value = "购方信息")
  public PurchaserInfo getPurchaser() {
    return purchaser;
  }

  public void setPurchaser(PurchaserInfo purchaser) {
    this.purchaser = purchaser;
  }

  @JsonIgnore
  public PreInvoiceInfo seller (SellerInfo seller) {
    this.seller = seller;
    return this;
  }

   /**
   * 销方信息
   * @return seller
  **/
  @ApiModelProperty(value = "销方信息")
  public SellerInfo getSeller() {
    return seller;
  }

  public void setSeller(SellerInfo seller) {
    this.seller = seller;
  }

  @JsonIgnore
  public PreInvoiceInfo control (InvoiceControlInfo control) {
    this.control = control;
    return this;
  }

   /**
   * 发票控制项
   * @return control
  **/
  @ApiModelProperty(value = "发票控制项")
  public InvoiceControlInfo getControl() {
    return control;
  }

  public void setControl(InvoiceControlInfo control) {
    this.control = control;
  }

  @JsonIgnore
  public PreInvoiceInfo redInfo (RedInfo redInfo) {
    this.redInfo = redInfo;
    return this;
  }

   /**
   * 发票红冲信息(用于开具红字发票)
   * @return redInfo
  **/
  @ApiModelProperty(value = "发票红冲信息(用于开具红字发票)")
  public RedInfo getRedInfo() {
    return redInfo;
  }

  public void setRedInfo(RedInfo redInfo) {
    this.redInfo = redInfo;
  }

  @JsonIgnore
  public PreInvoiceInfo vehicleInfo (VehicleInfo vehicleInfo) {
    this.vehicleInfo = vehicleInfo;
    return this;
  }

   /**
   * 机动车信息(用于开具机动车发票)
   * @return vehicleInfo
  **/
  @ApiModelProperty(value = "机动车信息(用于开具机动车发票)")
  public VehicleInfo getVehicleInfo() {
    return vehicleInfo;
  }

  public void setVehicleInfo(VehicleInfo vehicleInfo) {
    this.vehicleInfo = vehicleInfo;
  }

  @JsonIgnore
  public PreInvoiceInfo amountInfo (InvoiceAmountInfo amountInfo) {
    this.amountInfo = amountInfo;
    return this;
  }

   /**
   * 合计金额
   * @return amountInfo
  **/
  @ApiModelProperty(value = "合计金额")
  public InvoiceAmountInfo getAmountInfo() {
    return amountInfo;
  }

  public void setAmountInfo(InvoiceAmountInfo amountInfo) {
    this.amountInfo = amountInfo;
  }

  @JsonIgnore
  public PreInvoiceInfo remark (String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public PreInvoiceInfo listGoodsName (String listGoodsName) {
    this.listGoodsName = listGoodsName;
    return this;
  }

   /**
   * 销货清单标题（默认情况下，系统会自动按照发票的最大行数判定是否使用销货清单。如果调用方主动设置了这个字段属性，那么在行数没有达到阈值时，也会使用销货清单，且第一行明细中的名称就是此字段的值）
   * @return listGoodsName
  **/
  @ApiModelProperty(value = "销货清单标题（默认情况下，系统会自动按照发票的最大行数判定是否使用销货清单。如果调用方主动设置了这个字段属性，那么在行数没有达到阈值时，也会使用销货清单，且第一行明细中的名称就是此字段的值）")
  public String getListGoodsName() {
    return listGoodsName;
  }

  public void setListGoodsName(String listGoodsName) {
    this.listGoodsName = listGoodsName;
  }

  @JsonIgnore
  public PreInvoiceInfo details (List<InvoiceDetailInfo> details) {
    this.details = details;
    return this;
  }

  public PreInvoiceInfo addDetailsItem(InvoiceDetailInfo detailsItem) {
    this.details.add(detailsItem);
    return this;
  }

   /**
   * 发票明细
   * @return details
  **/
  @ApiModelProperty(value = "发票明细")
  public List<InvoiceDetailInfo> getDetails() {
    return details;
  }

  public void setDetails(List<InvoiceDetailInfo> details) {
    this.details = details;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PreInvoiceInfo preInvoiceInfo = (PreInvoiceInfo) o;
    return Objects.equals(this.pid, preInvoiceInfo.pid) &&
        Objects.equals(this.invoiceType, preInvoiceInfo.invoiceType) &&
        Objects.equals(this.operator, preInvoiceInfo.operator) &&
        Objects.equals(this.purchaser, preInvoiceInfo.purchaser) &&
        Objects.equals(this.seller, preInvoiceInfo.seller) &&
        Objects.equals(this.control, preInvoiceInfo.control) &&
        Objects.equals(this.redInfo, preInvoiceInfo.redInfo) &&
        Objects.equals(this.vehicleInfo, preInvoiceInfo.vehicleInfo) &&
        Objects.equals(this.amountInfo, preInvoiceInfo.amountInfo) &&
        Objects.equals(this.remark, preInvoiceInfo.remark) &&
        Objects.equals(this.listGoodsName, preInvoiceInfo.listGoodsName) &&
        Objects.equals(this.details, preInvoiceInfo.details);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pid, invoiceType, operator, purchaser, seller, control, redInfo, vehicleInfo, amountInfo, remark, listGoodsName, details);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PreInvoiceInfo {\n");
    
    sb.append("    pid: ").append(toIndentedString(pid)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    operator: ").append(toIndentedString(operator)).append("\n");
    sb.append("    purchaser: ").append(toIndentedString(purchaser)).append("\n");
    sb.append("    seller: ").append(toIndentedString(seller)).append("\n");
    sb.append("    control: ").append(toIndentedString(control)).append("\n");
    sb.append("    redInfo: ").append(toIndentedString(redInfo)).append("\n");
    sb.append("    vehicleInfo: ").append(toIndentedString(vehicleInfo)).append("\n");
    sb.append("    amountInfo: ").append(toIndentedString(amountInfo)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    listGoodsName: ").append(toIndentedString(listGoodsName)).append("\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
