package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforcecloud.open.client.model.DiscountInfo;
import com.xforcecloud.open.client.model.InvoiceDetailAmountInfo;
import com.xforcecloud.open.client.model.ProductionInfo;
import com.xforcecloud.open.client.model.TaxInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 发票明细信息
 */
@ApiModel(description = "发票明细信息")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class PrintInvoiceDetail {
  @JsonProperty("productionInfo")
  private ProductionInfo productionInfo = null;

  @JsonProperty("amountInfo")
  private InvoiceDetailAmountInfo amountInfo = null;

  @JsonProperty("discountInfo")
  private DiscountInfo discountInfo = null;

  @JsonProperty("taxInfo")
  private TaxInfo taxInfo = null;

  @JsonIgnore
  public PrintInvoiceDetail productionInfo (ProductionInfo productionInfo) {
    this.productionInfo = productionInfo;
    return this;
  }

   /**
   * 发票明细商品或劳务信息
   * @return productionInfo
  **/
  @ApiModelProperty(value = "发票明细商品或劳务信息")
  public ProductionInfo getProductionInfo() {
    return productionInfo;
  }

  public void setProductionInfo(ProductionInfo productionInfo) {
    this.productionInfo = productionInfo;
  }

  @JsonIgnore
  public PrintInvoiceDetail amountInfo (InvoiceDetailAmountInfo amountInfo) {
    this.amountInfo = amountInfo;
    return this;
  }

   /**
   * 发票明细金额信息
   * @return amountInfo
  **/
  @ApiModelProperty(value = "发票明细金额信息")
  public InvoiceDetailAmountInfo getAmountInfo() {
    return amountInfo;
  }

  public void setAmountInfo(InvoiceDetailAmountInfo amountInfo) {
    this.amountInfo = amountInfo;
  }

  @JsonIgnore
  public PrintInvoiceDetail discountInfo (DiscountInfo discountInfo) {
    this.discountInfo = discountInfo;
    return this;
  }

   /**
   * 折扣信息
   * @return discountInfo
  **/
  @ApiModelProperty(value = "折扣信息")
  public DiscountInfo getDiscountInfo() {
    return discountInfo;
  }

  public void setDiscountInfo(DiscountInfo discountInfo) {
    this.discountInfo = discountInfo;
  }

  @JsonIgnore
  public PrintInvoiceDetail taxInfo (TaxInfo taxInfo) {
    this.taxInfo = taxInfo;
    return this;
  }

   /**
   * 税收信息
   * @return taxInfo
  **/
  @ApiModelProperty(value = "税收信息")
  public TaxInfo getTaxInfo() {
    return taxInfo;
  }

  public void setTaxInfo(TaxInfo taxInfo) {
    this.taxInfo = taxInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PrintInvoiceDetail printInvoiceDetail = (PrintInvoiceDetail) o;
    return Objects.equals(this.productionInfo, printInvoiceDetail.productionInfo) &&
        Objects.equals(this.amountInfo, printInvoiceDetail.amountInfo) &&
        Objects.equals(this.discountInfo, printInvoiceDetail.discountInfo) &&
        Objects.equals(this.taxInfo, printInvoiceDetail.taxInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(productionInfo, amountInfo, discountInfo, taxInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PrintInvoiceDetail {\n");
    
    sb.append("    productionInfo: ").append(toIndentedString(productionInfo)).append("\n");
    sb.append("    amountInfo: ").append(toIndentedString(amountInfo)).append("\n");
    sb.append("    discountInfo: ").append(toIndentedString(discountInfo)).append("\n");
    sb.append("    taxInfo: ").append(toIndentedString(taxInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
