package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforcecloud.open.client.model.InvoiceAmountInfo;
import com.xforcecloud.open.client.model.InvoiceControlInfo;
import com.xforcecloud.open.client.model.Operator;
import com.xforcecloud.open.client.model.PrintInvoiceDetail;
import com.xforcecloud.open.client.model.PurchaserInfo;
import com.xforcecloud.open.client.model.RedInfo;
import com.xforcecloud.open.client.model.SellerInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 发票开具信息
 */
@ApiModel(description = "发票开具信息")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class PrintInvoices {
  @JsonProperty("pid")
  private String pid = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("cipherText")
  private String cipherText = null;

  @JsonProperty("cipherTextTwoCode")
  private String cipherTextTwoCode = null;

  @JsonProperty("listGoodsName")
  private String listGoodsName = null;

  @JsonProperty("makeInvoiceSource")
  private String makeInvoiceSource = "2";

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("invoiceDate")
  private String invoiceDate = null;

  @JsonProperty("operator")
  private Operator operator = null;

  @JsonProperty("purchaser")
  private PurchaserInfo purchaser = null;

  @JsonProperty("seller")
  private SellerInfo seller = null;

  @JsonProperty("redInfo")
  private RedInfo redInfo = null;

  @JsonProperty("amountInfo")
  private InvoiceAmountInfo amountInfo = null;

  @JsonProperty("control")
  private InvoiceControlInfo control = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("details")
  private List<PrintInvoiceDetail> details = new ArrayList<PrintInvoiceDetail>();

  @JsonIgnore
  public PrintInvoices pid (String pid) {
    this.pid = pid;
    return this;
  }

   /**
   * 预制发票ID(税控打印只需传此值)
   * @return pid
  **/
  @ApiModelProperty(value = "预制发票ID(税控打印只需传此值)")
  public String getPid() {
    return pid;
  }

  public void setPid(String pid) {
    this.pid = pid;
  }

  @JsonIgnore
  public PrintInvoices invoiceType (String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型(s-专票, c-普票, ju-卷票, v-机动车票, ce-电票)
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型(s-专票, c-普票, ju-卷票, v-机动车票, ce-电票)")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public PrintInvoices invoiceCode (String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码(税控打印只需传此值)
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码(税控打印只需传此值)")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public PrintInvoices invoiceNo (String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码(税控打印只需传此值)
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码(税控打印只需传此值)")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public PrintInvoices checkCode (String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * 校验码
   * @return checkCode
  **/
  @ApiModelProperty(value = "校验码")
  public String getCheckCode() {
    return checkCode;
  }

  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }

  @JsonIgnore
  public PrintInvoices cipherText (String cipherText) {
    this.cipherText = cipherText;
    return this;
  }

   /**
   * 密文
   * @return cipherText
  **/
  @ApiModelProperty(value = "密文")
  public String getCipherText() {
    return cipherText;
  }

  public void setCipherText(String cipherText) {
    this.cipherText = cipherText;
  }

  @JsonIgnore
  public PrintInvoices cipherTextTwoCode (String cipherTextTwoCode) {
    this.cipherTextTwoCode = cipherTextTwoCode;
    return this;
  }

   /**
   * 发票二维码密文(汉信码)
   * @return cipherTextTwoCode
  **/
  @ApiModelProperty(value = "发票二维码密文(汉信码)")
  public String getCipherTextTwoCode() {
    return cipherTextTwoCode;
  }

  public void setCipherTextTwoCode(String cipherTextTwoCode) {
    this.cipherTextTwoCode = cipherTextTwoCode;
  }

  @JsonIgnore
  public PrintInvoices listGoodsName (String listGoodsName) {
    this.listGoodsName = listGoodsName;
    return this;
  }

   /**
   * 销货清单标题（默认情况下，系统会自动按照发票的最大行数判定是否使用销货清单。如果调用方主动设置了这个字段属性，那么在行数没有达到阈值时，也会使用销货清单，且第一行明细中的名称就是此字段的值）
   * @return listGoodsName
  **/
  @ApiModelProperty(value = "销货清单标题（默认情况下，系统会自动按照发票的最大行数判定是否使用销货清单。如果调用方主动设置了这个字段属性，那么在行数没有达到阈值时，也会使用销货清单，且第一行明细中的名称就是此字段的值）")
  public String getListGoodsName() {
    return listGoodsName;
  }

  public void setListGoodsName(String listGoodsName) {
    this.listGoodsName = listGoodsName;
  }

  @JsonIgnore
  public PrintInvoices makeInvoiceSource (String makeInvoiceSource) {
    this.makeInvoiceSource = makeInvoiceSource;
    return this;
  }

   /**
   * 发票开具来源(1-百望 2-航信 订制打印时发票基础样式判断依据,默认航信)
   * @return makeInvoiceSource
  **/
  @ApiModelProperty(value = "发票开具来源(1-百望 2-航信 订制打印时发票基础样式判断依据,默认航信)")
  public String getMakeInvoiceSource() {
    return makeInvoiceSource;
  }

  public void setMakeInvoiceSource(String makeInvoiceSource) {
    this.makeInvoiceSource = makeInvoiceSource;
  }

  @JsonIgnore
  public PrintInvoices machineCode (String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 机器码
   * @return machineCode
  **/
  @ApiModelProperty(value = "机器码")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public PrintInvoices invoiceDate (String invoiceDate) {
    this.invoiceDate = invoiceDate;
    return this;
  }

   /**
   * 开票日期(yyyyMMdd)
   * @return invoiceDate
  **/
  @ApiModelProperty(value = "开票日期(yyyyMMdd)")
  public String getInvoiceDate() {
    return invoiceDate;
  }

  public void setInvoiceDate(String invoiceDate) {
    this.invoiceDate = invoiceDate;
  }

  @JsonIgnore
  public PrintInvoices operator (Operator operator) {
    this.operator = operator;
    return this;
  }

   /**
   * 经办人
   * @return operator
  **/
  @ApiModelProperty(value = "经办人")
  public Operator getOperator() {
    return operator;
  }

  public void setOperator(Operator operator) {
    this.operator = operator;
  }

  @JsonIgnore
  public PrintInvoices purchaser (PurchaserInfo purchaser) {
    this.purchaser = purchaser;
    return this;
  }

   /**
   * 购方信息
   * @return purchaser
  **/
  @ApiModelProperty(value = "购方信息")
  public PurchaserInfo getPurchaser() {
    return purchaser;
  }

  public void setPurchaser(PurchaserInfo purchaser) {
    this.purchaser = purchaser;
  }

  @JsonIgnore
  public PrintInvoices seller (SellerInfo seller) {
    this.seller = seller;
    return this;
  }

   /**
   * 销方信息
   * @return seller
  **/
  @ApiModelProperty(value = "销方信息")
  public SellerInfo getSeller() {
    return seller;
  }

  public void setSeller(SellerInfo seller) {
    this.seller = seller;
  }

  @JsonIgnore
  public PrintInvoices redInfo (RedInfo redInfo) {
    this.redInfo = redInfo;
    return this;
  }

   /**
   * 发票红冲信息
   * @return redInfo
  **/
  @ApiModelProperty(value = "发票红冲信息")
  public RedInfo getRedInfo() {
    return redInfo;
  }

  public void setRedInfo(RedInfo redInfo) {
    this.redInfo = redInfo;
  }

  @JsonIgnore
  public PrintInvoices amountInfo (InvoiceAmountInfo amountInfo) {
    this.amountInfo = amountInfo;
    return this;
  }

   /**
   * 合计金额信息
   * @return amountInfo
  **/
  @ApiModelProperty(value = "合计金额信息")
  public InvoiceAmountInfo getAmountInfo() {
    return amountInfo;
  }

  public void setAmountInfo(InvoiceAmountInfo amountInfo) {
    this.amountInfo = amountInfo;
  }

  @JsonIgnore
  public PrintInvoices control (InvoiceControlInfo control) {
    this.control = control;
    return this;
  }

   /**
   * 发票控制项
   * @return control
  **/
  @ApiModelProperty(value = "发票控制项")
  public InvoiceControlInfo getControl() {
    return control;
  }

  public void setControl(InvoiceControlInfo control) {
    this.control = control;
  }

  @JsonIgnore
  public PrintInvoices remark (String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public PrintInvoices details (List<PrintInvoiceDetail> details) {
    this.details = details;
    return this;
  }

  public PrintInvoices addDetailsItem(PrintInvoiceDetail detailsItem) {
    this.details.add(detailsItem);
    return this;
  }

   /**
   * 发票明细
   * @return details
  **/
  @ApiModelProperty(value = "发票明细")
  public List<PrintInvoiceDetail> getDetails() {
    return details;
  }

  public void setDetails(List<PrintInvoiceDetail> details) {
    this.details = details;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PrintInvoices printInvoices = (PrintInvoices) o;
    return Objects.equals(this.pid, printInvoices.pid) &&
        Objects.equals(this.invoiceType, printInvoices.invoiceType) &&
        Objects.equals(this.invoiceCode, printInvoices.invoiceCode) &&
        Objects.equals(this.invoiceNo, printInvoices.invoiceNo) &&
        Objects.equals(this.checkCode, printInvoices.checkCode) &&
        Objects.equals(this.cipherText, printInvoices.cipherText) &&
        Objects.equals(this.cipherTextTwoCode, printInvoices.cipherTextTwoCode) &&
        Objects.equals(this.listGoodsName, printInvoices.listGoodsName) &&
        Objects.equals(this.makeInvoiceSource, printInvoices.makeInvoiceSource) &&
        Objects.equals(this.machineCode, printInvoices.machineCode) &&
        Objects.equals(this.invoiceDate, printInvoices.invoiceDate) &&
        Objects.equals(this.operator, printInvoices.operator) &&
        Objects.equals(this.purchaser, printInvoices.purchaser) &&
        Objects.equals(this.seller, printInvoices.seller) &&
        Objects.equals(this.redInfo, printInvoices.redInfo) &&
        Objects.equals(this.amountInfo, printInvoices.amountInfo) &&
        Objects.equals(this.control, printInvoices.control) &&
        Objects.equals(this.remark, printInvoices.remark) &&
        Objects.equals(this.details, printInvoices.details);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pid, invoiceType, invoiceCode, invoiceNo, checkCode, cipherText, cipherTextTwoCode, listGoodsName, makeInvoiceSource, machineCode, invoiceDate, operator, purchaser, seller, redInfo, amountInfo, control, remark, details);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PrintInvoices {\n");
    
    sb.append("    pid: ").append(toIndentedString(pid)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    checkCode: ").append(toIndentedString(checkCode)).append("\n");
    sb.append("    cipherText: ").append(toIndentedString(cipherText)).append("\n");
    sb.append("    cipherTextTwoCode: ").append(toIndentedString(cipherTextTwoCode)).append("\n");
    sb.append("    listGoodsName: ").append(toIndentedString(listGoodsName)).append("\n");
    sb.append("    makeInvoiceSource: ").append(toIndentedString(makeInvoiceSource)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    invoiceDate: ").append(toIndentedString(invoiceDate)).append("\n");
    sb.append("    operator: ").append(toIndentedString(operator)).append("\n");
    sb.append("    purchaser: ").append(toIndentedString(purchaser)).append("\n");
    sb.append("    seller: ").append(toIndentedString(seller)).append("\n");
    sb.append("    redInfo: ").append(toIndentedString(redInfo)).append("\n");
    sb.append("    amountInfo: ").append(toIndentedString(amountInfo)).append("\n");
    sb.append("    control: ").append(toIndentedString(control)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
