package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 商品或劳务信息
 */
@ApiModel(description = "商品或劳务信息")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class ProductionInfo {
  @JsonProperty("cargoCode")
  private String cargoCode = null;

  @JsonProperty("cargoName")
  private String cargoName = null;

  @JsonProperty("quantityUnit")
  private String quantityUnit = null;

  @JsonProperty("itemSpec")
  private String itemSpec = null;

  @JsonProperty("commodityCode")
  private String commodityCode = null;

  @JsonIgnore
  public ProductionInfo cargoCode (String cargoCode) {
    this.cargoCode = cargoCode;
    return this;
  }

   /**
   * 货物或应税劳务编码(税编)
   * @return cargoCode
  **/
  @ApiModelProperty(value = "货物或应税劳务编码(税编)")
  public String getCargoCode() {
    return cargoCode;
  }

  public void setCargoCode(String cargoCode) {
    this.cargoCode = cargoCode;
  }

  @JsonIgnore
  public ProductionInfo cargoName (String cargoName) {
    this.cargoName = cargoName;
    return this;
  }

   /**
   * 货物或应税劳务名称
   * @return cargoName
  **/
  @ApiModelProperty(value = "货物或应税劳务名称")
  public String getCargoName() {
    return cargoName;
  }

  public void setCargoName(String cargoName) {
    this.cargoName = cargoName;
  }

  @JsonIgnore
  public ProductionInfo quantityUnit (String quantityUnit) {
    this.quantityUnit = quantityUnit;
    return this;
  }

   /**
   * 单位
   * @return quantityUnit
  **/
  @ApiModelProperty(value = "单位")
  public String getQuantityUnit() {
    return quantityUnit;
  }

  public void setQuantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
  }

  @JsonIgnore
  public ProductionInfo itemSpec (String itemSpec) {
    this.itemSpec = itemSpec;
    return this;
  }

   /**
   * 规格型号
   * @return itemSpec
  **/
  @ApiModelProperty(value = "规格型号")
  public String getItemSpec() {
    return itemSpec;
  }

  public void setItemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
  }

  @JsonIgnore
  public ProductionInfo commodityCode (String commodityCode) {
    this.commodityCode = commodityCode;
    return this;
  }

   /**
   * 商品自编码(最大19位)
   * @return commodityCode
  **/
  @ApiModelProperty(value = "商品自编码(最大19位)")
  public String getCommodityCode() {
    return commodityCode;
  }

  public void setCommodityCode(String commodityCode) {
    this.commodityCode = commodityCode;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProductionInfo productionInfo = (ProductionInfo) o;
    return Objects.equals(this.cargoCode, productionInfo.cargoCode) &&
        Objects.equals(this.cargoName, productionInfo.cargoName) &&
        Objects.equals(this.quantityUnit, productionInfo.quantityUnit) &&
        Objects.equals(this.itemSpec, productionInfo.itemSpec) &&
        Objects.equals(this.commodityCode, productionInfo.commodityCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cargoCode, cargoName, quantityUnit, itemSpec, commodityCode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProductionInfo {\n");
    
    sb.append("    cargoCode: ").append(toIndentedString(cargoCode)).append("\n");
    sb.append("    cargoName: ").append(toIndentedString(cargoName)).append("\n");
    sb.append("    quantityUnit: ").append(toIndentedString(quantityUnit)).append("\n");
    sb.append("    itemSpec: ").append(toIndentedString(itemSpec)).append("\n");
    sb.append("    commodityCode: ").append(toIndentedString(commodityCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
