package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 发票红冲信息
 */
@ApiModel(description = "发票红冲信息")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class RedInfo {
  @JsonProperty("originalInvoiceCode")
  private String originalInvoiceCode = null;

  @JsonProperty("originalInvoiceNo")
  private String originalInvoiceNo = null;

  @JsonProperty("redNotificationNo")
  private String redNotificationNo = null;

  @JsonIgnore
  public RedInfo originalInvoiceCode (String originalInvoiceCode) {
    this.originalInvoiceCode = originalInvoiceCode;
    return this;
  }

   /**
   * 原发票代码
   * @return originalInvoiceCode
  **/
  @ApiModelProperty(value = "原发票代码")
  public String getOriginalInvoiceCode() {
    return originalInvoiceCode;
  }

  public void setOriginalInvoiceCode(String originalInvoiceCode) {
    this.originalInvoiceCode = originalInvoiceCode;
  }

  @JsonIgnore
  public RedInfo originalInvoiceNo (String originalInvoiceNo) {
    this.originalInvoiceNo = originalInvoiceNo;
    return this;
  }

   /**
   * 原发票号码
   * @return originalInvoiceNo
  **/
  @ApiModelProperty(value = "原发票号码")
  public String getOriginalInvoiceNo() {
    return originalInvoiceNo;
  }

  public void setOriginalInvoiceNo(String originalInvoiceNo) {
    this.originalInvoiceNo = originalInvoiceNo;
  }

  @JsonIgnore
  public RedInfo redNotificationNo (String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
    return this;
  }

   /**
   * 红字信息编号
   * @return redNotificationNo
  **/
  @ApiModelProperty(value = "红字信息编号")
  public String getRedNotificationNo() {
    return redNotificationNo;
  }

  public void setRedNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RedInfo redInfo = (RedInfo) o;
    return Objects.equals(this.originalInvoiceCode, redInfo.originalInvoiceCode) &&
        Objects.equals(this.originalInvoiceNo, redInfo.originalInvoiceNo) &&
        Objects.equals(this.redNotificationNo, redInfo.redNotificationNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(originalInvoiceCode, originalInvoiceNo, redNotificationNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RedInfo {\n");
    
    sb.append("    originalInvoiceCode: ").append(toIndentedString(originalInvoiceCode)).append("\n");
    sb.append("    originalInvoiceNo: ").append(toIndentedString(originalInvoiceNo)).append("\n");
    sb.append("    redNotificationNo: ").append(toIndentedString(redNotificationNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
