package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 外部签收的物品信息
 */
@ApiModel(description = "外部签收的物品信息")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class SignGoodsInfo {
  @JsonProperty("goodsId")
  private Long goodsId = null;

  @JsonProperty("goodsType")
  private Integer goodsType = null;

  @JsonProperty("invoiceSheet")
  private Integer invoiceSheet = null;

  @JsonIgnore
  public SignGoodsInfo goodsId (Long goodsId) {
    this.goodsId = goodsId;
    return this;
  }

   /**
   * 物品ID
   * @return goodsId
  **/
  @ApiModelProperty(value = "物品ID")
  public Long getGoodsId() {
    return goodsId;
  }

  public void setGoodsId(Long goodsId) {
    this.goodsId = goodsId;
  }

  @JsonIgnore
  public SignGoodsInfo goodsType (Integer goodsType) {
    this.goodsType = goodsType;
    return this;
  }

   /**
   * 物品类型
   * @return goodsType
  **/
  @ApiModelProperty(value = "物品类型")
  public Integer getGoodsType() {
    return goodsType;
  }

  public void setGoodsType(Integer goodsType) {
    this.goodsType = goodsType;
  }

  @JsonIgnore
  public SignGoodsInfo invoiceSheet (Integer invoiceSheet) {
    this.invoiceSheet = invoiceSheet;
    return this;
  }

   /**
   * 联次
   * @return invoiceSheet
  **/
  @ApiModelProperty(value = "联次")
  public Integer getInvoiceSheet() {
    return invoiceSheet;
  }

  public void setInvoiceSheet(Integer invoiceSheet) {
    this.invoiceSheet = invoiceSheet;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SignGoodsInfo signGoodsInfo = (SignGoodsInfo) o;
    return Objects.equals(this.goodsId, signGoodsInfo.goodsId) &&
        Objects.equals(this.goodsType, signGoodsInfo.goodsType) &&
        Objects.equals(this.invoiceSheet, signGoodsInfo.invoiceSheet);
  }

  @Override
  public int hashCode() {
    return Objects.hash(goodsId, goodsType, invoiceSheet);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SignGoodsInfo {\n");
    
    sb.append("    goodsId: ").append(toIndentedString(goodsId)).append("\n");
    sb.append("    goodsType: ").append(toIndentedString(goodsType)).append("\n");
    sb.append("    invoiceSheet: ").append(toIndentedString(invoiceSheet)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
