package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforcecloud.open.client.model.SignGoodsInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 物流外部签收对象
 */
@ApiModel(description = "物流外部签收对象")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class SignLgtOutObj {
  @JsonProperty("waybillNo")
  private String waybillNo = null;

  @JsonProperty("expressCode")
  private String expressCode = null;

  @JsonProperty("businessLgtStatus")
  private Integer businessLgtStatus = null;

  @JsonProperty("businessSignTime")
  private String businessSignTime = null;

  @JsonProperty("senderGroupId")
  private Long senderGroupId = null;

  @JsonProperty("senderOrgId")
  private Long senderOrgId = null;

  @JsonProperty("receiverGroupId")
  private Long receiverGroupId = null;

  @JsonProperty("receiverOrgId")
  private Long receiverOrgId = null;

  @JsonProperty("goodsDetial")
  private List<SignGoodsInfo> goodsDetial = new ArrayList<SignGoodsInfo>();

  @JsonIgnore
  public SignLgtOutObj waybillNo (String waybillNo) {
    this.waybillNo = waybillNo;
    return this;
  }

   /**
   * 运单号
   * @return waybillNo
  **/
  @ApiModelProperty(value = "运单号")
  public String getWaybillNo() {
    return waybillNo;
  }

  public void setWaybillNo(String waybillNo) {
    this.waybillNo = waybillNo;
  }

  @JsonIgnore
  public SignLgtOutObj expressCode (String expressCode) {
    this.expressCode = expressCode;
    return this;
  }

   /**
   * 快递公司代码
   * @return expressCode
  **/
  @ApiModelProperty(value = "快递公司代码")
  public String getExpressCode() {
    return expressCode;
  }

  public void setExpressCode(String expressCode) {
    this.expressCode = expressCode;
  }

  @JsonIgnore
  public SignLgtOutObj businessLgtStatus (Integer businessLgtStatus) {
    this.businessLgtStatus = businessLgtStatus;
    return this;
  }

   /**
   * 业务物流签收状态
   * @return businessLgtStatus
  **/
  @ApiModelProperty(value = "业务物流签收状态")
  public Integer getBusinessLgtStatus() {
    return businessLgtStatus;
  }

  public void setBusinessLgtStatus(Integer businessLgtStatus) {
    this.businessLgtStatus = businessLgtStatus;
  }

  @JsonIgnore
  public SignLgtOutObj businessSignTime (String businessSignTime) {
    this.businessSignTime = businessSignTime;
    return this;
  }

   /**
   * 业务物流签收时间
   * @return businessSignTime
  **/
  @ApiModelProperty(value = "业务物流签收时间")
  public String getBusinessSignTime() {
    return businessSignTime;
  }

  public void setBusinessSignTime(String businessSignTime) {
    this.businessSignTime = businessSignTime;
  }

  @JsonIgnore
  public SignLgtOutObj senderGroupId (Long senderGroupId) {
    this.senderGroupId = senderGroupId;
    return this;
  }

   /**
   * 寄件方集团ID
   * @return senderGroupId
  **/
  @ApiModelProperty(value = "寄件方集团ID")
  public Long getSenderGroupId() {
    return senderGroupId;
  }

  public void setSenderGroupId(Long senderGroupId) {
    this.senderGroupId = senderGroupId;
  }

  @JsonIgnore
  public SignLgtOutObj senderOrgId (Long senderOrgId) {
    this.senderOrgId = senderOrgId;
    return this;
  }

   /**
   * 寄件方组织ID
   * @return senderOrgId
  **/
  @ApiModelProperty(value = "寄件方组织ID")
  public Long getSenderOrgId() {
    return senderOrgId;
  }

  public void setSenderOrgId(Long senderOrgId) {
    this.senderOrgId = senderOrgId;
  }

  @JsonIgnore
  public SignLgtOutObj receiverGroupId (Long receiverGroupId) {
    this.receiverGroupId = receiverGroupId;
    return this;
  }

   /**
   * 收件方集团ID
   * @return receiverGroupId
  **/
  @ApiModelProperty(value = "收件方集团ID")
  public Long getReceiverGroupId() {
    return receiverGroupId;
  }

  public void setReceiverGroupId(Long receiverGroupId) {
    this.receiverGroupId = receiverGroupId;
  }

  @JsonIgnore
  public SignLgtOutObj receiverOrgId (Long receiverOrgId) {
    this.receiverOrgId = receiverOrgId;
    return this;
  }

   /**
   * 收件方组织ID
   * @return receiverOrgId
  **/
  @ApiModelProperty(value = "收件方组织ID")
  public Long getReceiverOrgId() {
    return receiverOrgId;
  }

  public void setReceiverOrgId(Long receiverOrgId) {
    this.receiverOrgId = receiverOrgId;
  }

  @JsonIgnore
  public SignLgtOutObj goodsDetial (List<SignGoodsInfo> goodsDetial) {
    this.goodsDetial = goodsDetial;
    return this;
  }

  public SignLgtOutObj addGoodsDetialItem(SignGoodsInfo goodsDetialItem) {
    this.goodsDetial.add(goodsDetialItem);
    return this;
  }

   /**
   * 签收的物品明细
   * @return goodsDetial
  **/
  @ApiModelProperty(value = "签收的物品明细")
  public List<SignGoodsInfo> getGoodsDetial() {
    return goodsDetial;
  }

  public void setGoodsDetial(List<SignGoodsInfo> goodsDetial) {
    this.goodsDetial = goodsDetial;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SignLgtOutObj signLgtOutObj = (SignLgtOutObj) o;
    return Objects.equals(this.waybillNo, signLgtOutObj.waybillNo) &&
        Objects.equals(this.expressCode, signLgtOutObj.expressCode) &&
        Objects.equals(this.businessLgtStatus, signLgtOutObj.businessLgtStatus) &&
        Objects.equals(this.businessSignTime, signLgtOutObj.businessSignTime) &&
        Objects.equals(this.senderGroupId, signLgtOutObj.senderGroupId) &&
        Objects.equals(this.senderOrgId, signLgtOutObj.senderOrgId) &&
        Objects.equals(this.receiverGroupId, signLgtOutObj.receiverGroupId) &&
        Objects.equals(this.receiverOrgId, signLgtOutObj.receiverOrgId) &&
        Objects.equals(this.goodsDetial, signLgtOutObj.goodsDetial);
  }

  @Override
  public int hashCode() {
    return Objects.hash(waybillNo, expressCode, businessLgtStatus, businessSignTime, senderGroupId, senderOrgId, receiverGroupId, receiverOrgId, goodsDetial);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SignLgtOutObj {\n");
    
    sb.append("    waybillNo: ").append(toIndentedString(waybillNo)).append("\n");
    sb.append("    expressCode: ").append(toIndentedString(expressCode)).append("\n");
    sb.append("    businessLgtStatus: ").append(toIndentedString(businessLgtStatus)).append("\n");
    sb.append("    businessSignTime: ").append(toIndentedString(businessSignTime)).append("\n");
    sb.append("    senderGroupId: ").append(toIndentedString(senderGroupId)).append("\n");
    sb.append("    senderOrgId: ").append(toIndentedString(senderOrgId)).append("\n");
    sb.append("    receiverGroupId: ").append(toIndentedString(receiverGroupId)).append("\n");
    sb.append("    receiverOrgId: ").append(toIndentedString(receiverOrgId)).append("\n");
    sb.append("    goodsDetial: ").append(toIndentedString(goodsDetial)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
