package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 发票开具结果状态
 */
@ApiModel(description = "发票开具结果状态")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class StatusInfo {
  @JsonProperty("processFlag")
  private String processFlag = null;

  @JsonProperty("processRemark")
  private String processRemark = null;

  @JsonIgnore
  public StatusInfo processFlag (String processFlag) {
    this.processFlag = processFlag;
    return this;
  }

   /**
   * 处理状态 0-开具失败 1-开具成功 7-开具异常
   * @return processFlag
  **/
  @ApiModelProperty(value = "处理状态 0-开具失败 1-开具成功 7-开具异常")
  public String getProcessFlag() {
    return processFlag;
  }

  public void setProcessFlag(String processFlag) {
    this.processFlag = processFlag;
  }

  @JsonIgnore
  public StatusInfo processRemark (String processRemark) {
    this.processRemark = processRemark;
    return this;
  }

   /**
   * 处理信息
   * @return processRemark
  **/
  @ApiModelProperty(value = "处理信息")
  public String getProcessRemark() {
    return processRemark;
  }

  public void setProcessRemark(String processRemark) {
    this.processRemark = processRemark;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StatusInfo statusInfo = (StatusInfo) o;
    return Objects.equals(this.processFlag, statusInfo.processFlag) &&
        Objects.equals(this.processRemark, statusInfo.processRemark);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processFlag, processRemark);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StatusInfo {\n");
    
    sb.append("    processFlag: ").append(toIndentedString(processFlag)).append("\n");
    sb.append("    processRemark: ").append(toIndentedString(processRemark)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
