package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 税收信息
 */
@ApiModel(description = "税收信息")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class TaxInfo {
  @JsonProperty("goodsTaxNo")
  private String goodsTaxNo = null;

  @JsonProperty("goodsNoVer")
  private String goodsNoVer = null;

  @JsonProperty("taxItem")
  private String taxItem = null;

  @JsonProperty("taxRate")
  private BigDecimal taxRate = null;

  @JsonProperty("taxPre")
  private Boolean taxPre = false;

  @JsonProperty("taxPreCon")
  private String taxPreCon = null;

  @JsonProperty("zeroTax")
  private String zeroTax = null;

  @JsonIgnore
  public TaxInfo goodsTaxNo (String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
    return this;
  }

   /**
   * 税收分类编码
   * @return goodsTaxNo
  **/
  @ApiModelProperty(value = "税收分类编码")
  public String getGoodsTaxNo() {
    return goodsTaxNo;
  }

  public void setGoodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
  }

  @JsonIgnore
  public TaxInfo goodsNoVer (String goodsNoVer) {
    this.goodsNoVer = goodsNoVer;
    return this;
  }

   /**
   * 税编版本号
   * @return goodsNoVer
  **/
  @ApiModelProperty(value = "税编版本号")
  public String getGoodsNoVer() {
    return goodsNoVer;
  }

  public void setGoodsNoVer(String goodsNoVer) {
    this.goodsNoVer = goodsNoVer;
  }

  @JsonIgnore
  public TaxInfo taxItem (String taxItem) {
    this.taxItem = taxItem;
    return this;
  }

   /**
   * 税目
   * @return taxItem
  **/
  @ApiModelProperty(value = "税目")
  public String getTaxItem() {
    return taxItem;
  }

  public void setTaxItem(String taxItem) {
    this.taxItem = taxItem;
  }

  @JsonIgnore
  public TaxInfo taxRate (BigDecimal taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率(例如，16%传0.16)
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率(例如，16%传0.16)")
  public BigDecimal getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(BigDecimal taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public TaxInfo taxPre (Boolean taxPre) {
    this.taxPre = taxPre;
    return this;
  }

   /**
   * 是否享受税收优惠政策，默认值 false
   * @return taxPre
  **/
  @ApiModelProperty(value = "是否享受税收优惠政策，默认值 false")
  public Boolean getTaxPre() {
    return taxPre;
  }

  public void setTaxPre(Boolean taxPre) {
    this.taxPre = taxPre;
  }

  @JsonIgnore
  public TaxInfo taxPreCon (String taxPreCon) {
    this.taxPreCon = taxPreCon;
    return this;
  }

   /**
   * 享受税收优惠政策内容(在请求时无须传值)
   * @return taxPreCon
  **/
  @ApiModelProperty(value = "享受税收优惠政策内容(在请求时无须传值)")
  public String getTaxPreCon() {
    return taxPreCon;
  }

  public void setTaxPreCon(String taxPreCon) {
    this.taxPreCon = taxPreCon;
  }

  @JsonIgnore
  public TaxInfo zeroTax (String zeroTax) {
    this.zeroTax = zeroTax;
    return this;
  }

   /**
   * 税率标志 (空-非0税率；0-出口退税 1-免税 2-不征税 3-普通0税率)
   * @return zeroTax
  **/
  @ApiModelProperty(value = "税率标志 (空-非0税率；0-出口退税 1-免税 2-不征税 3-普通0税率)")
  public String getZeroTax() {
    return zeroTax;
  }

  public void setZeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TaxInfo taxInfo = (TaxInfo) o;
    return Objects.equals(this.goodsTaxNo, taxInfo.goodsTaxNo) &&
        Objects.equals(this.goodsNoVer, taxInfo.goodsNoVer) &&
        Objects.equals(this.taxItem, taxInfo.taxItem) &&
        Objects.equals(this.taxRate, taxInfo.taxRate) &&
        Objects.equals(this.taxPre, taxInfo.taxPre) &&
        Objects.equals(this.taxPreCon, taxInfo.taxPreCon) &&
        Objects.equals(this.zeroTax, taxInfo.zeroTax);
  }

  @Override
  public int hashCode() {
    return Objects.hash(goodsTaxNo, goodsNoVer, taxItem, taxRate, taxPre, taxPreCon, zeroTax);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TaxInfo {\n");
    
    sb.append("    goodsTaxNo: ").append(toIndentedString(goodsTaxNo)).append("\n");
    sb.append("    goodsNoVer: ").append(toIndentedString(goodsNoVer)).append("\n");
    sb.append("    taxItem: ").append(toIndentedString(taxItem)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    taxPre: ").append(toIndentedString(taxPre)).append("\n");
    sb.append("    taxPreCon: ").append(toIndentedString(taxPreCon)).append("\n");
    sb.append("    zeroTax: ").append(toIndentedString(zeroTax)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
