package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforcecloud.open.client.model.TaxInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 机动车信息
 */
@ApiModel(description = "机动车信息")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class VehicleInfo {
  @JsonProperty("certificationNo")
  private String certificationNo = null;

  @JsonProperty("commodityInspectionNo")
  private String commodityInspectionNo = null;

  @JsonProperty("engineNo")
  private String engineNo = null;

  @JsonProperty("importCertificateNo")
  private String importCertificateNo = null;

  @JsonProperty("manufacturerName")
  private String manufacturerName = null;

  @JsonProperty("maxCapacity")
  private String maxCapacity = null;

  @JsonProperty("productionArea")
  private String productionArea = null;

  @JsonProperty("purchaserId")
  private String purchaserId = null;

  @JsonProperty("taxInfo")
  private TaxInfo taxInfo = null;

  @JsonProperty("taxPaidProof")
  private String taxPaidProof = null;

  @JsonProperty("tonnage")
  private String tonnage = null;

  @JsonProperty("vehicleBrand")
  private String vehicleBrand = null;

  @JsonProperty("vehicleNo")
  private String vehicleNo = null;

  @JsonProperty("vehicleType")
  private String vehicleType = null;

  @JsonIgnore
  public VehicleInfo certificationNo (String certificationNo) {
    this.certificationNo = certificationNo;
    return this;
  }

   /**
   * 机动车合格证编号
   * @return certificationNo
  **/
  @ApiModelProperty(value = "机动车合格证编号")
  public String getCertificationNo() {
    return certificationNo;
  }

  public void setCertificationNo(String certificationNo) {
    this.certificationNo = certificationNo;
  }

  @JsonIgnore
  public VehicleInfo commodityInspectionNo (String commodityInspectionNo) {
    this.commodityInspectionNo = commodityInspectionNo;
    return this;
  }

   /**
   * 商检单号
   * @return commodityInspectionNo
  **/
  @ApiModelProperty(value = "商检单号")
  public String getCommodityInspectionNo() {
    return commodityInspectionNo;
  }

  public void setCommodityInspectionNo(String commodityInspectionNo) {
    this.commodityInspectionNo = commodityInspectionNo;
  }

  @JsonIgnore
  public VehicleInfo engineNo (String engineNo) {
    this.engineNo = engineNo;
    return this;
  }

   /**
   * 发动机号
   * @return engineNo
  **/
  @ApiModelProperty(value = "发动机号")
  public String getEngineNo() {
    return engineNo;
  }

  public void setEngineNo(String engineNo) {
    this.engineNo = engineNo;
  }

  @JsonIgnore
  public VehicleInfo importCertificateNo (String importCertificateNo) {
    this.importCertificateNo = importCertificateNo;
    return this;
  }

   /**
   * 进口机动车合格证编号
   * @return importCertificateNo
  **/
  @ApiModelProperty(value = "进口机动车合格证编号")
  public String getImportCertificateNo() {
    return importCertificateNo;
  }

  public void setImportCertificateNo(String importCertificateNo) {
    this.importCertificateNo = importCertificateNo;
  }

  @JsonIgnore
  public VehicleInfo manufacturerName (String manufacturerName) {
    this.manufacturerName = manufacturerName;
    return this;
  }

   /**
   * 生产企业名称
   * @return manufacturerName
  **/
  @ApiModelProperty(value = "生产企业名称")
  public String getManufacturerName() {
    return manufacturerName;
  }

  public void setManufacturerName(String manufacturerName) {
    this.manufacturerName = manufacturerName;
  }

  @JsonIgnore
  public VehicleInfo maxCapacity (String maxCapacity) {
    this.maxCapacity = maxCapacity;
    return this;
  }

   /**
   * 限乘人数
   * @return maxCapacity
  **/
  @ApiModelProperty(value = "限乘人数")
  public String getMaxCapacity() {
    return maxCapacity;
  }

  public void setMaxCapacity(String maxCapacity) {
    this.maxCapacity = maxCapacity;
  }

  @JsonIgnore
  public VehicleInfo productionArea (String productionArea) {
    this.productionArea = productionArea;
    return this;
  }

   /**
   * 产地
   * @return productionArea
  **/
  @ApiModelProperty(value = "产地")
  public String getProductionArea() {
    return productionArea;
  }

  public void setProductionArea(String productionArea) {
    this.productionArea = productionArea;
  }

  @JsonIgnore
  public VehicleInfo purchaserId (String purchaserId) {
    this.purchaserId = purchaserId;
    return this;
  }

   /**
   * 消费者身份证号码
   * @return purchaserId
  **/
  @ApiModelProperty(value = "消费者身份证号码")
  public String getPurchaserId() {
    return purchaserId;
  }

  public void setPurchaserId(String purchaserId) {
    this.purchaserId = purchaserId;
  }

  @JsonIgnore
  public VehicleInfo taxInfo (TaxInfo taxInfo) {
    this.taxInfo = taxInfo;
    return this;
  }

   /**
   * 税收信息
   * @return taxInfo
  **/
  @ApiModelProperty(value = "税收信息")
  public TaxInfo getTaxInfo() {
    return taxInfo;
  }

  public void setTaxInfo(TaxInfo taxInfo) {
    this.taxInfo = taxInfo;
  }

  @JsonIgnore
  public VehicleInfo taxPaidProof (String taxPaidProof) {
    this.taxPaidProof = taxPaidProof;
    return this;
  }

   /**
   * 完税凭证号码
   * @return taxPaidProof
  **/
  @ApiModelProperty(value = "完税凭证号码")
  public String getTaxPaidProof() {
    return taxPaidProof;
  }

  public void setTaxPaidProof(String taxPaidProof) {
    this.taxPaidProof = taxPaidProof;
  }

  @JsonIgnore
  public VehicleInfo tonnage (String tonnage) {
    this.tonnage = tonnage;
    return this;
  }

   /**
   * 吨位
   * @return tonnage
  **/
  @ApiModelProperty(value = "吨位")
  public String getTonnage() {
    return tonnage;
  }

  public void setTonnage(String tonnage) {
    this.tonnage = tonnage;
  }

  @JsonIgnore
  public VehicleInfo vehicleBrand (String vehicleBrand) {
    this.vehicleBrand = vehicleBrand;
    return this;
  }

   /**
   * 车辆品牌
   * @return vehicleBrand
  **/
  @ApiModelProperty(value = "车辆品牌")
  public String getVehicleBrand() {
    return vehicleBrand;
  }

  public void setVehicleBrand(String vehicleBrand) {
    this.vehicleBrand = vehicleBrand;
  }

  @JsonIgnore
  public VehicleInfo vehicleNo (String vehicleNo) {
    this.vehicleNo = vehicleNo;
    return this;
  }

   /**
   * 车辆识别号
   * @return vehicleNo
  **/
  @ApiModelProperty(value = "车辆识别号")
  public String getVehicleNo() {
    return vehicleNo;
  }

  public void setVehicleNo(String vehicleNo) {
    this.vehicleNo = vehicleNo;
  }

  @JsonIgnore
  public VehicleInfo vehicleType (String vehicleType) {
    this.vehicleType = vehicleType;
    return this;
  }

   /**
   * 车辆类型
   * @return vehicleType
  **/
  @ApiModelProperty(value = "车辆类型")
  public String getVehicleType() {
    return vehicleType;
  }

  public void setVehicleType(String vehicleType) {
    this.vehicleType = vehicleType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VehicleInfo vehicleInfo = (VehicleInfo) o;
    return Objects.equals(this.certificationNo, vehicleInfo.certificationNo) &&
        Objects.equals(this.commodityInspectionNo, vehicleInfo.commodityInspectionNo) &&
        Objects.equals(this.engineNo, vehicleInfo.engineNo) &&
        Objects.equals(this.importCertificateNo, vehicleInfo.importCertificateNo) &&
        Objects.equals(this.manufacturerName, vehicleInfo.manufacturerName) &&
        Objects.equals(this.maxCapacity, vehicleInfo.maxCapacity) &&
        Objects.equals(this.productionArea, vehicleInfo.productionArea) &&
        Objects.equals(this.purchaserId, vehicleInfo.purchaserId) &&
        Objects.equals(this.taxInfo, vehicleInfo.taxInfo) &&
        Objects.equals(this.taxPaidProof, vehicleInfo.taxPaidProof) &&
        Objects.equals(this.tonnage, vehicleInfo.tonnage) &&
        Objects.equals(this.vehicleBrand, vehicleInfo.vehicleBrand) &&
        Objects.equals(this.vehicleNo, vehicleInfo.vehicleNo) &&
        Objects.equals(this.vehicleType, vehicleInfo.vehicleType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(certificationNo, commodityInspectionNo, engineNo, importCertificateNo, manufacturerName, maxCapacity, productionArea, purchaserId, taxInfo, taxPaidProof, tonnage, vehicleBrand, vehicleNo, vehicleType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VehicleInfo {\n");
    
    sb.append("    certificationNo: ").append(toIndentedString(certificationNo)).append("\n");
    sb.append("    commodityInspectionNo: ").append(toIndentedString(commodityInspectionNo)).append("\n");
    sb.append("    engineNo: ").append(toIndentedString(engineNo)).append("\n");
    sb.append("    importCertificateNo: ").append(toIndentedString(importCertificateNo)).append("\n");
    sb.append("    manufacturerName: ").append(toIndentedString(manufacturerName)).append("\n");
    sb.append("    maxCapacity: ").append(toIndentedString(maxCapacity)).append("\n");
    sb.append("    productionArea: ").append(toIndentedString(productionArea)).append("\n");
    sb.append("    purchaserId: ").append(toIndentedString(purchaserId)).append("\n");
    sb.append("    taxInfo: ").append(toIndentedString(taxInfo)).append("\n");
    sb.append("    taxPaidProof: ").append(toIndentedString(taxPaidProof)).append("\n");
    sb.append("    tonnage: ").append(toIndentedString(tonnage)).append("\n");
    sb.append("    vehicleBrand: ").append(toIndentedString(vehicleBrand)).append("\n");
    sb.append("    vehicleNo: ").append(toIndentedString(vehicleNo)).append("\n");
    sb.append("    vehicleType: ").append(toIndentedString(vehicleType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
