package com.xforcecloud.open.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 发票验证请求
 */
@ApiModel(description = "发票验证请求")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-04-03T18:24:05.378+08:00")
@JsonInclude(NON_NULL)
public class VerifyRequest {
  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("paperDrewDate")
  private String paperDrewDate = null;

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("amount")
  private String amount = null;

  @JsonProperty("tenantCode")
  private String tenantCode = null;

  @JsonProperty("customerNo")
  private String customerNo = null;

  @JsonProperty("serialNo")
  private String serialNo = null;

  @JsonIgnore
  public VerifyRequest invoiceCode (String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public VerifyRequest invoiceNo (String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public VerifyRequest paperDrewDate (String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
    return this;
  }

   /**
   * 开票日期
   * @return paperDrewDate
  **/
  @ApiModelProperty(value = "开票日期")
  public String getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  @JsonIgnore
  public VerifyRequest checkCode (String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * 校验码（增值税普票必填）
   * @return checkCode
  **/
  @ApiModelProperty(value = "校验码（增值税普票必填）")
  public String getCheckCode() {
    return checkCode;
  }

  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }

  @JsonIgnore
  public VerifyRequest amount (String amount) {
    this.amount = amount;
    return this;
  }

   /**
   * 金额（不含税金额，增值税专票必填）
   * @return amount
  **/
  @ApiModelProperty(value = "金额（不含税金额，增值税专票必填）")
  public String getAmount() {
    return amount;
  }

  public void setAmount(String amount) {
    this.amount = amount;
  }

  @JsonIgnore
  public VerifyRequest tenantCode (String tenantCode) {
    this.tenantCode = tenantCode;
    return this;
  }

   /**
   * 租户代码
   * @return tenantCode
  **/
  @ApiModelProperty(value = "租户代码")
  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  @JsonIgnore
  public VerifyRequest customerNo (String customerNo) {
    this.customerNo = customerNo;
    return this;
  }

   /**
   * 回调用户单号
   * @return customerNo
  **/
  @ApiModelProperty(value = "回调用户单号")
  public String getCustomerNo() {
    return customerNo;
  }

  public void setCustomerNo(String customerNo) {
    this.customerNo = customerNo;
  }

  @JsonIgnore
  public VerifyRequest serialNo (String serialNo) {
    this.serialNo = serialNo;
    return this;
  }

   /**
   * 序列号
   * @return serialNo
  **/
  @ApiModelProperty(value = "序列号")
  public String getSerialNo() {
    return serialNo;
  }

  public void setSerialNo(String serialNo) {
    this.serialNo = serialNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VerifyRequest verifyRequest = (VerifyRequest) o;
    return Objects.equals(this.invoiceCode, verifyRequest.invoiceCode) &&
        Objects.equals(this.invoiceNo, verifyRequest.invoiceNo) &&
        Objects.equals(this.paperDrewDate, verifyRequest.paperDrewDate) &&
        Objects.equals(this.checkCode, verifyRequest.checkCode) &&
        Objects.equals(this.amount, verifyRequest.amount) &&
        Objects.equals(this.tenantCode, verifyRequest.tenantCode) &&
        Objects.equals(this.customerNo, verifyRequest.customerNo) &&
        Objects.equals(this.serialNo, verifyRequest.serialNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceCode, invoiceNo, paperDrewDate, checkCode, amount, tenantCode, customerNo, serialNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VerifyRequest {\n");
    
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    checkCode: ").append(toIndentedString(checkCode)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    tenantCode: ").append(toIndentedString(tenantCode)).append("\n");
    sb.append("    customerNo: ").append(toIndentedString(customerNo)).append("\n");
    sb.append("    serialNo: ").append(toIndentedString(serialNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
