/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.config;

import com.xforceplus.action.trail.reactor.filters.ActionTrailFilter;
import com.xforceplus.action.trail.reactor.filters.GatewayContextFilter;
import com.xforceplus.action.trail.reactor.filters.VisitRecordLogFilter;
import com.xforceplus.action.trail.service.VisitRecordService;
import com.xforceplus.action.trail.service.impl.ActionTrailServiceImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableFeignClients(value={"com.xforceplus"})
@Import(value={ActionTrailServiceImpl.class})
public class GlobalFilterConfig {
    @Bean
    @ConditionalOnProperty(prefix="action.trail", name={"type"}, havingValue="gateway", matchIfMissing=false)
    public GlobalFilter actionTrailFilter() {
        return new ActionTrailFilter();
    }

    @Bean
    @ConditionalOnProperty(prefix="action.trail", name={"needs-body"}, havingValue="true", matchIfMissing=false)
    public GlobalFilter gatewayContextFilter() {
        return new GatewayContextFilter();
    }

    @Bean
    @ConditionalOnProperty(prefix="action.visitrecord", name={"type"}, havingValue="gateway", matchIfMissing=false)
    public VisitRecordLogFilter visitRecordLogFilter() {
        return new VisitRecordLogFilter();
    }

    @Bean
    public VisitRecordService visitRecordService() {
        return new VisitRecordService();
    }
}

