/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.config;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
@EnableAsync
public class ThreadPoolConfig
extends AsyncConfigurerSupport
implements ApplicationContextAware {
    private static final Logger logger = LogManager.getLogger(ThreadPoolConfig.class);
    private static final String THREAD_NAME_PREFIX = "ActionTrail-";
    @Value(value="${action.trail.threadpool.corePoolSize:1}")
    private int corePoolSize;
    @Value(value="${action.trail.threadpool.maxPoolSize:1}")
    private int maxPoolSize;
    @Value(value="${action.trail.threadpool.queueCapacity:2}")
    private int queueCapacity;
    private ThreadPoolTaskExecutor executor;
    @Value(value="false")
    private boolean isExecutorInit;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (!this.isExecutorInit) {
            logger.info("Start ThreadPoolConfig.");
            this.executor = new ThreadPoolTaskExecutor();
            this.executor.setCorePoolSize(this.corePoolSize);
            this.executor.setMaxPoolSize(this.maxPoolSize);
            this.executor.setQueueCapacity(this.queueCapacity);
            this.executor.setThreadNamePrefix(THREAD_NAME_PREFIX);
            this.executor.initialize();
            this.isExecutorInit = true;
        }
    }

    public Executor getAsyncExecutor() {
        return this.executor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return (ex, method, params) -> {
            logger.error("Exception message - " + ex.getMessage());
            logger.error("Method name - " + method.getName());
            for (Object param : params) {
                logger.error("Parameter value - " + param);
            }
        };
    }
}

