/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.reactor.filters;

import com.xforceplus.action.trail.reactor.filters.GatewayContext;
import io.netty.buffer.ByteBufAllocator;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GatewayContextFilter
implements GlobalFilter,
Ordered {
    private static final List<HttpMessageReader<?>> messageReaders = HandlerStrategies.withDefaults().messageReaders();
    private Logger log = LoggerFactory.getLogger(GatewayContextFilter.class);

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        if (request.getMethod() == HttpMethod.GET) {
            return chain.filter(exchange);
        }
        Map attributes = exchange.getAttributes();
        String needActiontrail = (String)attributes.get("NEED_ACTIONTRAIL");
        if (StringUtils.isEmpty((Object)needActiontrail) || !needActiontrail.equals("TRUE")) {
            return chain.filter(exchange);
        }
        String path = request.getPath().pathWithinApplication().value();
        GatewayContext gatewayContext = new GatewayContext();
        gatewayContext.setPath(path);
        exchange.getAttributes().put("cacheGatewayContext", gatewayContext);
        HttpHeaders headers = request.getHeaders();
        MediaType contentType = headers.getContentType();
        this.log.debug("HttpMethod:{},Url:{}", (Object)request.getMethod(), (Object)request.getURI().getRawPath());
        if (request.getMethod() == HttpMethod.POST || request.getMethod() == HttpMethod.PUT || request.getMethod() == HttpMethod.PATCH) {
            if (!MediaType.APPLICATION_JSON.equals((Object)contentType) && !MediaType.APPLICATION_JSON_UTF8.equals((Object)contentType)) {
                return chain.filter(exchange);
            }
            Mono<Void> voidMono = this.readBody(exchange, chain, gatewayContext);
            return voidMono;
        }
        return chain.filter(exchange);
    }

    private Mono<Void> readFormData(ServerWebExchange exchange, GatewayFilterChain chain, GatewayContext gatewayContext) {
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders headers = request.getHeaders();
        return exchange.getFormData().doOnNext(multiValueMap -> {
            gatewayContext.setFormData((MultiValueMap<String, String>)multiValueMap);
            this.log.debug("Post x-www-form-urlencoded:{}", multiValueMap);
            this.log.debug("end-------------------------------------------------");
        }).then(Mono.defer(() -> {
            Charset charset = headers.getContentType().getCharset();
            charset = charset == null ? StandardCharsets.UTF_8 : charset;
            String charsetName = charset.name();
            MultiValueMap<String, String> formData = gatewayContext.getFormData();
            if (null == formData || formData.isEmpty()) {
                return chain.filter(exchange);
            }
            StringBuilder formDataBodyBuilder = new StringBuilder();
            try {
                for (Map.Entry entry : formData.entrySet()) {
                    String entryKey = (String)entry.getKey();
                    List entryValue = (List)entry.getValue();
                    if (entryValue.size() > 1) {
                        for (String value : entryValue) {
                            formDataBodyBuilder.append(entryKey).append("=").append(URLEncoder.encode(value, charsetName)).append("&");
                        }
                        continue;
                    }
                    formDataBodyBuilder.append(entryKey).append("=").append(URLEncoder.encode((String)entryValue.get(0), charsetName)).append("&");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            String formDataBodyString = "";
            if (formDataBodyBuilder.length() > 0) {
                formDataBodyString = formDataBodyBuilder.substring(0, formDataBodyBuilder.length() - 1);
            }
            final byte[] bodyBytes = formDataBodyString.getBytes(charset);
            final int contentLength = bodyBytes.length;
            ServerHttpRequestDecorator decorator = new ServerHttpRequestDecorator(request){

                public HttpHeaders getHeaders() {
                    HttpHeaders httpHeaders = new HttpHeaders();
                    httpHeaders.putAll((Map)super.getHeaders());
                    if (contentLength > 0) {
                        httpHeaders.setContentLength((long)contentLength);
                    } else {
                        httpHeaders.set("Transfer-Encoding", "chunked");
                    }
                    return httpHeaders;
                }

                public Flux<DataBuffer> getBody() {
                    return DataBufferUtils.read((Resource)new ByteArrayResource(bodyBytes), (DataBufferFactory)new NettyDataBufferFactory(ByteBufAllocator.DEFAULT), (int)contentLength);
                }
            };
            ServerWebExchange mutateExchange = exchange.mutate().request((ServerHttpRequest)decorator).build();
            return chain.filter(mutateExchange);
        }));
    }

    private Mono<Void> readBody(ServerWebExchange exchange, GatewayFilterChain chain, GatewayContext gatewayContext) {
        Flux body = exchange.getRequest().getBody();
        Mono dataBufferMono = DataBufferUtils.join((Publisher)body);
        return dataBufferMono.flatMap(dataBuffer -> {
            byte[] bytes = new byte[dataBuffer.readableByteCount()];
            dataBuffer.read(bytes);
            DataBufferUtils.release((DataBuffer)dataBuffer);
            final Flux cachedFlux = Flux.defer(() -> {
                DataBuffer buffer = exchange.getResponse().bufferFactory().wrap(bytes);
                DataBufferUtils.retain((DataBuffer)buffer);
                return Mono.just((Object)buffer);
            });
            ServerHttpRequestDecorator mutatedRequest = new ServerHttpRequestDecorator(exchange.getRequest()){

                public Flux<DataBuffer> getBody() {
                    return cachedFlux;
                }
            };
            ServerWebExchange mutatedExchange = exchange.mutate().request((ServerHttpRequest)mutatedRequest).build();
            return ServerRequest.create((ServerWebExchange)mutatedExchange, messageReaders).bodyToMono(String.class).doOnNext(objectValue -> {
                this.log.debug("PostBody:{}", objectValue);
                this.log.debug("end-------------------------------------------------");
                gatewayContext.setCacheBody((String)objectValue);
            }).then(chain.filter(mutatedExchange));
        }).switchIfEmpty(Mono.defer(() -> {
            String cacheBody = gatewayContext.getCacheBody();
            if (StringUtils.isEmpty((Object)cacheBody)) {
                return chain.filter(exchange);
            }
            return Mono.empty();
        }));
    }

    public int getOrder() {
        return 0x7FFFFFF2;
    }
}

