/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.reactor.filters;

import com.xforceplus.action.trail.service.VisitRecordService;
import com.xforceplus.tenantsecurity.utils.UUIDUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.annotation.Order;
import org.springframework.util.CollectionUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=0x7FFFFFFD)
public class VisitRecordLogFilter
implements WebFilter {
    private static final Logger log = LoggerFactory.getLogger(VisitRecordLogFilter.class);
    @Resource
    private VisitRecordService visitRecordService;
    @Value(value="${action.visitrecord.recordAll:false}")
    private String recordALL = "false";
    @Value(value="${action.visitrecord.recordPaths}")
    private List<String> recordPaths = new ArrayList<String>();

    public Mono<Void> filter(ServerWebExchange serverWebExchange, WebFilterChain webFilterChain) {
        log.info("\u5f00\u59cbVisitRecordLogFilter");
        String requestId = UUIDUtils.randomUUID();
        Date beginTime = new Date();
        String path = serverWebExchange.getRequest().getURI().getPath();
        boolean needRecord = this.isNeedRecord(path);
        log.info("needRecord==={}", (Object)needRecord);
        if (needRecord) {
            serverWebExchange.getResponse().getHeaders().set("requestId", requestId);
            this.visitRecordService.saveRequest(requestId, beginTime, serverWebExchange.getRequest());
        }
        return webFilterChain.filter(serverWebExchange).doFinally(p -> {
            log.info("\u7ed3\u675fVisitRecordLogFilter");
            if (needRecord) {
                Date endTime = new Date();
                long cost = endTime.getTime() - beginTime.getTime();
                String routeId = "no_route";
                boolean alreadyRouted = ServerWebExchangeUtils.isAlreadyRouted((ServerWebExchange)serverWebExchange);
                Route route = (Route)serverWebExchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
                if (route != null) {
                    routeId = route.getId();
                }
                if (needRecord) {
                    this.visitRecordService.saveResponse(requestId, routeId, String.valueOf(alreadyRouted), beginTime, endTime, serverWebExchange);
                }
            }
        });
    }

    private boolean isNeedRecord(String path) {
        if (StringUtils.equals((CharSequence)"true", (CharSequence)this.recordALL)) {
            return true;
        }
        if (!CollectionUtils.isEmpty(this.recordPaths)) {
            return this.recordPaths.stream().anyMatch(p -> path.contains((CharSequence)p));
        }
        return false;
    }
}

