/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.service;

import com.xforceplus.action.trail.client.VisitRecordClient;
import com.xforceplus.action.trail.utils.CookieUtils;
import com.xforceplus.action.trail.vo.MetricVisitRecordRequest;
import com.xforceplus.action.trail.vo.MetricVisitRecordResponse;
import com.xforceplus.tenantsecurity.utils.JsonUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.web.server.ServerWebExchange;

public class VisitRecordService {
    private static final Logger log = LoggerFactory.getLogger(VisitRecordService.class);
    @Resource
    private VisitRecordClient visitRecordClient;
    private ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(4, 8, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r);
        }
    }, new ThreadPoolExecutor.AbortPolicy());

    public void saveRequest(String requestId, Date requestDate, ServerHttpRequest request) {
        try {
            this.poolExecutor.execute(() -> {
                try {
                    this.doReallySaveRequest(requestId, requestDate, request);
                }
                catch (Throwable e) {
                    log.error("\u8bb0\u5f55\u8bbf\u95ee\u65e5\u5fd7\u8bf7\u6c42\u5931\u8d25\u3002requestId==" + requestId, e);
                }
            });
        }
        catch (Throwable e) {
            log.error("\u63d0\u4ea4\u8bb0\u5f55\u8bbf\u95ee\u65e5\u5fd7\u8bf7\u6c42\u4efb\u52a1\u5931\u8d25\u3002requestId==" + requestId, e);
        }
    }

    private void doReallySaveRequest(String requestId, Date requestTime, ServerHttpRequest request) {
        MetricVisitRecordRequest metricVisitRecordRequest = this.getMetricVisitRecordRequest(requestId, requestTime, request);
        this.visitRecordClient.saveRequest(metricVisitRecordRequest);
    }

    private MetricVisitRecordRequest getMetricVisitRecordRequest(String requestId, Date requestTime, ServerHttpRequest request) {
        MetricVisitRecordResponse metricVisitRecordRequest = new MetricVisitRecordResponse();
        metricVisitRecordRequest.setRequestId(requestId);
        String path = request.getURI().getPath();
        String method = request.getMethod().name();
        metricVisitRecordRequest.setPath(path);
        metricVisitRecordRequest.setMethod(method);
        Map<String, List<String>> headers = this.getHeaders(request);
        String token = CookieUtils.getCookieValue(request, "xforce-saas-token");
        if (StringUtils.isBlank((CharSequence)token)) {
            token = CookieUtils.getCookieValue(request, "x-app-token");
        }
        metricVisitRecordRequest.setToken(token);
        metricVisitRecordRequest.setClientInfo(this.getClientInfo(headers));
        metricVisitRecordRequest.setIp(this.getIp(headers));
        metricVisitRecordRequest.setHeaderJson(JsonUtils.toJson(headers));
        metricVisitRecordRequest.setRequestTime(DateFormatUtils.format((Date)requestTime, (String)"yyyy-MM-dd'T'HH:mm:ss SSS"));
        return metricVisitRecordRequest;
    }

    public void saveResponse(String requestId, String routeId, String areadyRouted, Date requestTime, Date responseTime, ServerWebExchange serverWebExchange) {
        try {
            this.poolExecutor.execute(() -> {
                try {
                    this.doReallySaveResponse(requestId, routeId, areadyRouted, requestTime, responseTime, serverWebExchange);
                }
                catch (Throwable e) {
                    log.error("\u8bb0\u5f55\u8bbf\u95ee\u65e5\u5fd7\u54cd\u5e94\u5931\u8d25\u3002requestId==" + requestId, e);
                }
            });
        }
        catch (Throwable e) {
            log.error("\u63d0\u4ea4\u8bb0\u5f55\u8bbf\u95ee\u65e5\u5fd7\u54cd\u5e94\u4efb\u52a1\u5931\u8d25\u3002requestId==" + requestId, e);
        }
    }

    private void doReallySaveResponse(String requestId, String routeId, String areadyRouted, Date requestTime, Date responseTime, ServerWebExchange serverWebExchange) {
        MetricVisitRecordResponse metricVisitRecordResponse = (MetricVisitRecordResponse)this.getMetricVisitRecordRequest(requestId, requestTime, serverWebExchange.getRequest());
        metricVisitRecordResponse.setRequestId(requestId);
        metricVisitRecordResponse.setRouteId(routeId);
        metricVisitRecordResponse.setAreadyRouted(areadyRouted);
        int status = serverWebExchange.getResponse().getStatusCode().value();
        metricVisitRecordResponse.setResponseStatus(String.valueOf(status));
        metricVisitRecordResponse.setRequestTime(DateFormatUtils.format((Date)requestTime, (String)"yyyy-MM-dd'T'HH:mm:ss SSS"));
        metricVisitRecordResponse.setResponseTime(DateFormatUtils.format((Date)responseTime, (String)"yyyy-MM-dd'T'HH:mm:ss SSS"));
        this.visitRecordClient.saveResponse(metricVisitRecordResponse);
    }

    private String getIp(Map<String, List<String>> headers) {
        if (headers == null) {
            return null;
        }
        List<String> list = headers.get("X-Real-IP");
        if (!CollectionUtils.isEmpty(list)) {
            return list.get(0);
        }
        list = headers.get("X-Forwarded-For");
        if (!CollectionUtils.isEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    private String getClientInfo(Map<String, List<String>> headers) {
        if (headers == null) {
            return null;
        }
        List<String> list = headers.get("user-agent");
        if (!CollectionUtils.isEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    private Map<String, List<String>> getHeaders(ServerHttpRequest request) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        request.getHeaders().forEach((name, values) -> values.forEach(value -> headers.put((String)name, (List<String>)values)));
        return headers;
    }
}

