/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.reactor.filters;

import com.xforceplus.action.trail.reactor.filters.ActionTrailAsync;
import com.xforceplus.action.trail.reactor.filters.GatewayContext;
import com.xforceplus.action.trail.vo.EventExtendInfo;
import com.xforceplus.action.trail.vo.QueueElem;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ActionTrailFilter
implements GlobalFilter,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ActionTrailAsync trailAsync;

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        return chain.filter(exchange).then(Mono.fromRunnable(() -> {
            String isUdconfig;
            Map attributes = exchange.getAttributes();
            String needActiontrail = (String)attributes.get("NEED_ACTIONTRAIL");
            if (StringUtils.isEmpty((Object)needActiontrail) || !needActiontrail.equals("TRUE")) {
                return;
            }
            Route gatewayRoute = (Route)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
            ServerHttpRequest request = exchange.getRequest();
            String realIp = this.getRealRemoteIp(request);
            EventExtendInfo eventExtendInfo = new EventExtendInfo();
            eventExtendInfo.setRealRemoteIp(realIp);
            GatewayContext gatewayContext = (GatewayContext)exchange.getAttribute("cacheGatewayContext");
            if (null != gatewayContext) {
                eventExtendInfo.setRequestBody(gatewayContext.getCacheBody());
            }
            if (StringUtils.isEmpty((Object)(isUdconfig = (String)attributes.get("IS_UDCONFIG"))) || !isUdconfig.equals("TRUE")) {
                eventExtendInfo.setResourceId((String)attributes.get("RESOURCE_ID"));
                eventExtendInfo.setResourceCode((String)attributes.get("RESOURCE_CODE"));
                eventExtendInfo.setResourceName((String)attributes.get("RESOURCE_NAME"));
                eventExtendInfo.setResourceType((String)attributes.get("RESOURCE_TYPE"));
                eventExtendInfo.setUdConfig(false);
            } else {
                eventExtendInfo.setUdConfig(true);
            }
            Date beginTime = (Date)attributes.get("begin_time");
            Long costTime = System.currentTimeMillis() - beginTime.getTime();
            eventExtendInfo.setCostTime(costTime);
            String clientTrail = (String)attributes.get("CLIENT_TRAIL");
            if ("TRUE".equals(clientTrail)) {
                eventExtendInfo.setClientId((String)attributes.get("CLIENT_ID"));
                eventExtendInfo.setTenantId((String)attributes.get("TENANT_ID"));
                eventExtendInfo.setTenantName((String)attributes.get("TENANT_NAME"));
                eventExtendInfo.setResponseStatus(exchange.getResponse().getStatusCode().value());
            }
            if (!this.enqueue(gatewayRoute, request, eventExtendInfo)) {
                this.logger.warn("Failed to Enqueue ActionTrail. Route = {}.", (Object)gatewayRoute);
            } else {
                this.logger.debug("Enqueue ActionTrail Success. Route = {}", (Object)gatewayRoute);
            }
        }));
    }

    public boolean enqueue(Route gatewayRoute, ServerHttpRequest request, EventExtendInfo eventExtendInfo) {
        return this.trailAsync.enqueue(new QueueElem(gatewayRoute, request, eventExtendInfo));
    }

    public String getRealRemoteIp(ServerHttpRequest request) {
        String ip = request.getHeaders().getFirst("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddress().getHostString();
        } else {
            String[] splitIps = ip.split(",");
            ip = splitIps[splitIps.length - 1];
        }
        return ip;
    }

    public int getOrder() {
        return 0x7FFFFFF3;
    }
}

