/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.Deflater;
import java.util.zip.InflaterInputStream;
import org.springframework.util.Base64Utils;

public class CompressionUtils {
    private static final int BUFFER_SIZE = 1024;
    private static final int EOF = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(String value, int level) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Deflater deflater = new Deflater(level);
        try {
            deflater.setInput(value.getBytes(StandardCharsets.UTF_8));
            deflater.finish();
            byte[] buf = new byte[1024];
            while (!deflater.finished()) {
                int count = deflater.deflate(buf);
                bos.write(buf, 0, count);
            }
        }
        finally {
            deflater.end();
        }
        return bos.toByteArray();
    }

    public static byte[] uncompress(byte[] value) throws IOException {
        int c;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream bais = new ByteArrayInputStream(value);
        InflaterInputStream iis = new InflaterInputStream(bais);
        byte[] buf = new byte[1024];
        while ((c = iis.read(buf)) != -1) {
            baos.write(buf, 0, c);
        }
        baos.flush();
        return baos.toByteArray();
    }

    public static String encode(String json) {
        String base64 = CompressionUtils.encode(json, 1);
        return base64;
    }

    public static String encode(String json, int level) {
        String base64 = Base64Utils.encodeToString((byte[])CompressionUtils.compress(json, level));
        return base64;
    }

    public static String decode(String base64) {
        byte[] compressed = Base64Utils.decodeFromString((String)base64);
        try {
            byte[] uncompressed = CompressionUtils.uncompress(compressed);
            return new String(uncompressed, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return null;
        }
    }
}

