/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtUtil {
    private static String ISSUER = "xforceplus";
    private static String defaultSecret;
    private static final Logger logger;

    public static void setDefaultSecret(String defaultSecret) {
        JwtUtil.defaultSecret = defaultSecret;
    }

    public static Map<String, String> verifyToken(String token) {
        Map<String, String> claims = JwtUtil.decodeToken(token);
        String secret = defaultSecret;
        JwtUtil.verifyToken(secret, token);
        return claims;
    }

    public static Map<String, String> decodeToken(String token) throws TokenExpiredException {
        try {
            DecodedJWT decodedJWT = JWT.decode((String)token);
            Map<String, String> result = JwtUtil.getStringMapFromClaim(token, decodedJWT);
            return result;
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            String message = "\u89e3\u6790token\u5931\u8d25";
            logger.error("token: " + token + ", " + message);
            return null;
        }
    }

    private static Map<String, String> getStringMapFromClaim(String token, DecodedJWT decodedJWT) {
        Map claims = decodedJWT.getClaims();
        if (claims.isEmpty()) {
            String message = "\u89e3\u6790token\u5931\u8d25";
            logger.error("token: " + token + ", " + message);
            throw new JWTDecodeException(message);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : claims.entrySet()) {
            if (entry.getKey() == null) {
                logger.warn("entry.getKey() == null");
                continue;
            }
            if (entry.getValue() == null) {
                logger.warn("entry.getValue() == null");
                continue;
            }
            result.put((String)entry.getKey(), ((Claim)entry.getValue()).asString());
        }
        return result;
    }

    public static void verifyToken(String secret, String token) throws TokenExpiredException {
        try {
            Algorithm ALGORITHM = Algorithm.HMAC256((String)secret);
            JWTVerifier JWT_VERIFIER = JWT.require((Algorithm)ALGORITHM).withClaim("iss", ISSUER).build();
            JWT_VERIFIER.verify(token);
        }
        catch (TokenExpiredException e) {
            logger.info("token\u8fc7\u671f\uff0ctoken=={}", (Object)token);
            throw e;
        }
        catch (JWTVerificationException e) {
            logger.warn("token\u6821\u9a8c\u5931\u8d25\uff0ctoken=={}", (Object)token);
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u6790token\u5931\u8d25", e);
        }
    }

    static {
        logger = LoggerFactory.getLogger(JwtUtil.class);
    }
}

