/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.utils;

import com.auth0.jwt.exceptions.TokenExpiredException;
import com.xforceplus.action.trail.utils.CompressionUtils;
import com.xforceplus.action.trail.utils.CookieUtils;
import com.xforceplus.action.trail.utils.JwtUtil;
import com.xforceplus.action.trail.vo.UserSessionInfo;
import com.xforceplus.tenant.security.token.domain.UserType;
import io.geewit.web.utils.JsonUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;

public class TokenUtil {
    private static final Logger logger = LoggerFactory.getLogger(TokenUtil.class);

    public static UserSessionInfo getUserSessionInfo(ServerHttpRequest request) {
        String token = TokenUtil.extractToken(request);
        if (org.springframework.util.StringUtils.isEmpty((Object)token)) {
            return null;
        }
        String tkUserInfo = TokenUtil.extractUserInfo(token);
        if (org.springframework.util.StringUtils.isEmpty((Object)tkUserInfo)) {
            return null;
        }
        String userinfo = CompressionUtils.decode(tkUserInfo);
        UserSessionInfo authorizedUser = (UserSessionInfo)JsonUtils.fromJson((String)userinfo, UserSessionInfo.class);
        return authorizedUser;
    }

    public static String extractUserInfo(String token) {
        Map<String, String> claims = null;
        if (StringUtils.isNotBlank((CharSequence)token)) {
            try {
                claims = JwtUtil.verifyToken(token);
            }
            catch (TokenExpiredException e) {
                logger.info("ActionTrailFilter: token\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                return null;
            }
            catch (Exception e) {
                logger.info("ActionTrailFilter: token\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                return null;
            }
        }
        return (String)claims.get("userinfo");
    }

    public static String extractToken(ServerHttpRequest request) {
        String tokenKey = UserType.USER.tokenKey();
        String token = request.getHeaders().getFirst(tokenKey);
        if (StringUtils.isBlank((CharSequence)token)) {
            token = CookieUtils.getCookieValue(request, tokenKey);
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            MultiValueMap params = request.getQueryParams();
            tokenKey = "access_token";
            token = (String)params.getFirst((Object)tokenKey);
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            tokenKey = UserType.APPID.tokenKey();
            token = CookieUtils.getCookieValue(request, tokenKey);
        }
        return token;
    }
}

