/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.action.trail.vo.UserSessionInfo;
import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;

public class MetricEvent
implements Serializable {
    private String eventId;
    private String requestId;
    private String scheme;
    private String httpMethod;
    private String host;
    private String uri;
    private String path;
    private String serviceName;
    private String eventType;
    private Integer status;
    private String loginId;
    private Long tenantId;
    private String tenantName;
    private Long accountId;
    private String userName;
    private Long userId;
    private String tel;
    private String email;
    private String resourceId;
    private String resourceType;
    private String resourceCode;
    private String resourceName;
    private boolean admin;
    private Boolean isRead;
    private String ip;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date eventTime;
    private String machineHostName;
    private String machineIp;
    private String objectId;
    private String objectType;
    private String objectOperation;
    private String objectOperationDetail;
    private String requestBody;
    private String clientId;
    private Long costTime;
    private Integer responseStatus;

    private MetricEvent(Builder builder) {
        URI uri = builder.uri;
        UserSessionInfo userInfo = builder.userInfo;
        String serviceName = builder.serviceName;
        this.eventId = UUID.randomUUID().toString();
        this.scheme = uri.getScheme();
        this.httpMethod = builder.httpMethod;
        this.host = uri.getHost();
        this.uri = uri.toString();
        this.path = uri.getPath();
        this.serviceName = serviceName;
        if (null != userInfo) {
            this.loginId = userInfo.getLoginId();
            this.tenantId = userInfo.getTenantId();
            this.tenantName = userInfo.getTenantName();
            this.accountId = userInfo.getAccountId();
            this.userName = userInfo.getUsername();
            this.userId = userInfo.getId();
            this.admin = userInfo.isAdmin();
            this.email = userInfo.email;
            this.tel = userInfo.mobile;
        }
        this.eventTime = new Date();
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        if (StringUtils.isNotBlank((CharSequence)builder.clientId)) {
            this.clientId = builder.clientId;
            this.tenantId = builder.tenantId;
            this.tenantName = builder.tenantName;
        }
        this.costTime = builder.costTime;
        this.responseStatus = builder.responseStatus;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getHost() {
        return this.host;
    }

    public String getUri() {
        return this.uri;
    }

    public String getPath() {
        return this.path;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getEventType() {
        return this.eventType;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getLoginId() {
        return this.loginId;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public String getUserName() {
        return this.userName;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getTel() {
        return this.tel;
    }

    public String getEmail() {
        return this.email;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceCode() {
        return this.resourceCode;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public Boolean getIsRead() {
        return this.isRead;
    }

    public String getIp() {
        return this.ip;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public String getMachineHostName() {
        return this.machineHostName;
    }

    public String getMachineIp() {
        return this.machineIp;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getObjectOperation() {
        return this.objectOperation;
    }

    public String getObjectOperationDetail() {
        return this.objectOperationDetail;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Long getCostTime() {
        return this.costTime;
    }

    public Integer getResponseStatus() {
        return this.responseStatus;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void setResourceCode(String resourceCode) {
        this.resourceCode = resourceCode;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public void setIsRead(Boolean isRead) {
        this.isRead = isRead;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    public void setMachineHostName(String machineHostName) {
        this.machineHostName = machineHostName;
    }

    public void setMachineIp(String machineIp) {
        this.machineIp = machineIp;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public void setObjectOperation(String objectOperation) {
        this.objectOperation = objectOperation;
    }

    public void setObjectOperationDetail(String objectOperationDetail) {
        this.objectOperationDetail = objectOperationDetail;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setCostTime(Long costTime) {
        this.costTime = costTime;
    }

    public void setResponseStatus(Integer responseStatus) {
        this.responseStatus = responseStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricEvent)) {
            return false;
        }
        MetricEvent other = (MetricEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$eventId = this.getEventId();
        String other$eventId = other.getEventId();
        if (this$eventId == null ? other$eventId != null : !this$eventId.equals(other$eventId)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$scheme = this.getScheme();
        String other$scheme = other.getScheme();
        if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
            return false;
        }
        String this$httpMethod = this.getHttpMethod();
        String other$httpMethod = other.getHttpMethod();
        if (this$httpMethod == null ? other$httpMethod != null : !this$httpMethod.equals(other$httpMethod)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$loginId = this.getLoginId();
        String other$loginId = other.getLoginId();
        if (this$loginId == null ? other$loginId != null : !this$loginId.equals(other$loginId)) {
            return false;
        }
        Long this$tenantId = this.getTenantId();
        Long other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$tenantName = this.getTenantName();
        String other$tenantName = other.getTenantName();
        if (this$tenantName == null ? other$tenantName != null : !this$tenantName.equals(other$tenantName)) {
            return false;
        }
        Long this$accountId = this.getAccountId();
        Long other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !((Object)this$accountId).equals(other$accountId)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$tel = this.getTel();
        String other$tel = other.getTel();
        if (this$tel == null ? other$tel != null : !this$tel.equals(other$tel)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$resourceId = this.getResourceId();
        String other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId)) {
            return false;
        }
        String this$resourceType = this.getResourceType();
        String other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
            return false;
        }
        String this$resourceCode = this.getResourceCode();
        String other$resourceCode = other.getResourceCode();
        if (this$resourceCode == null ? other$resourceCode != null : !this$resourceCode.equals(other$resourceCode)) {
            return false;
        }
        String this$resourceName = this.getResourceName();
        String other$resourceName = other.getResourceName();
        if (this$resourceName == null ? other$resourceName != null : !this$resourceName.equals(other$resourceName)) {
            return false;
        }
        if (this.isAdmin() != other.isAdmin()) {
            return false;
        }
        Boolean this$isRead = this.getIsRead();
        Boolean other$isRead = other.getIsRead();
        if (this$isRead == null ? other$isRead != null : !((Object)this$isRead).equals(other$isRead)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        Date this$eventTime = this.getEventTime();
        Date other$eventTime = other.getEventTime();
        if (this$eventTime == null ? other$eventTime != null : !((Object)this$eventTime).equals(other$eventTime)) {
            return false;
        }
        String this$machineHostName = this.getMachineHostName();
        String other$machineHostName = other.getMachineHostName();
        if (this$machineHostName == null ? other$machineHostName != null : !this$machineHostName.equals(other$machineHostName)) {
            return false;
        }
        String this$machineIp = this.getMachineIp();
        String other$machineIp = other.getMachineIp();
        if (this$machineIp == null ? other$machineIp != null : !this$machineIp.equals(other$machineIp)) {
            return false;
        }
        String this$objectId = this.getObjectId();
        String other$objectId = other.getObjectId();
        if (this$objectId == null ? other$objectId != null : !this$objectId.equals(other$objectId)) {
            return false;
        }
        String this$objectType = this.getObjectType();
        String other$objectType = other.getObjectType();
        if (this$objectType == null ? other$objectType != null : !this$objectType.equals(other$objectType)) {
            return false;
        }
        String this$objectOperation = this.getObjectOperation();
        String other$objectOperation = other.getObjectOperation();
        if (this$objectOperation == null ? other$objectOperation != null : !this$objectOperation.equals(other$objectOperation)) {
            return false;
        }
        String this$objectOperationDetail = this.getObjectOperationDetail();
        String other$objectOperationDetail = other.getObjectOperationDetail();
        if (this$objectOperationDetail == null ? other$objectOperationDetail != null : !this$objectOperationDetail.equals(other$objectOperationDetail)) {
            return false;
        }
        String this$requestBody = this.getRequestBody();
        String other$requestBody = other.getRequestBody();
        if (this$requestBody == null ? other$requestBody != null : !this$requestBody.equals(other$requestBody)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        Long this$costTime = this.getCostTime();
        Long other$costTime = other.getCostTime();
        if (this$costTime == null ? other$costTime != null : !((Object)this$costTime).equals(other$costTime)) {
            return false;
        }
        Integer this$responseStatus = this.getResponseStatus();
        Integer other$responseStatus = other.getResponseStatus();
        return !(this$responseStatus == null ? other$responseStatus != null : !((Object)this$responseStatus).equals(other$responseStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetricEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $eventId = this.getEventId();
        result = result * 59 + ($eventId == null ? 43 : $eventId.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $scheme = this.getScheme();
        result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
        String $httpMethod = this.getHttpMethod();
        result = result * 59 + ($httpMethod == null ? 43 : $httpMethod.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $loginId = this.getLoginId();
        result = result * 59 + ($loginId == null ? 43 : $loginId.hashCode());
        Long $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $tenantName = this.getTenantName();
        result = result * 59 + ($tenantName == null ? 43 : $tenantName.hashCode());
        Long $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : ((Object)$accountId).hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $tel = this.getTel();
        result = result * 59 + ($tel == null ? 43 : $tel.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
        String $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
        String $resourceCode = this.getResourceCode();
        result = result * 59 + ($resourceCode == null ? 43 : $resourceCode.hashCode());
        String $resourceName = this.getResourceName();
        result = result * 59 + ($resourceName == null ? 43 : $resourceName.hashCode());
        result = result * 59 + (this.isAdmin() ? 79 : 97);
        Boolean $isRead = this.getIsRead();
        result = result * 59 + ($isRead == null ? 43 : ((Object)$isRead).hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        Date $eventTime = this.getEventTime();
        result = result * 59 + ($eventTime == null ? 43 : ((Object)$eventTime).hashCode());
        String $machineHostName = this.getMachineHostName();
        result = result * 59 + ($machineHostName == null ? 43 : $machineHostName.hashCode());
        String $machineIp = this.getMachineIp();
        result = result * 59 + ($machineIp == null ? 43 : $machineIp.hashCode());
        String $objectId = this.getObjectId();
        result = result * 59 + ($objectId == null ? 43 : $objectId.hashCode());
        String $objectType = this.getObjectType();
        result = result * 59 + ($objectType == null ? 43 : $objectType.hashCode());
        String $objectOperation = this.getObjectOperation();
        result = result * 59 + ($objectOperation == null ? 43 : $objectOperation.hashCode());
        String $objectOperationDetail = this.getObjectOperationDetail();
        result = result * 59 + ($objectOperationDetail == null ? 43 : $objectOperationDetail.hashCode());
        String $requestBody = this.getRequestBody();
        result = result * 59 + ($requestBody == null ? 43 : $requestBody.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        Long $costTime = this.getCostTime();
        result = result * 59 + ($costTime == null ? 43 : ((Object)$costTime).hashCode());
        Integer $responseStatus = this.getResponseStatus();
        result = result * 59 + ($responseStatus == null ? 43 : ((Object)$responseStatus).hashCode());
        return result;
    }

    public String toString() {
        return "MetricEvent(eventId=" + this.getEventId() + ", requestId=" + this.getRequestId() + ", scheme=" + this.getScheme() + ", httpMethod=" + this.getHttpMethod() + ", host=" + this.getHost() + ", uri=" + this.getUri() + ", path=" + this.getPath() + ", serviceName=" + this.getServiceName() + ", eventType=" + this.getEventType() + ", status=" + this.getStatus() + ", loginId=" + this.getLoginId() + ", tenantId=" + this.getTenantId() + ", tenantName=" + this.getTenantName() + ", accountId=" + this.getAccountId() + ", userName=" + this.getUserName() + ", userId=" + this.getUserId() + ", tel=" + this.getTel() + ", email=" + this.getEmail() + ", resourceId=" + this.getResourceId() + ", resourceType=" + this.getResourceType() + ", resourceCode=" + this.getResourceCode() + ", resourceName=" + this.getResourceName() + ", admin=" + this.isAdmin() + ", isRead=" + this.getIsRead() + ", ip=" + this.getIp() + ", eventTime=" + this.getEventTime() + ", machineHostName=" + this.getMachineHostName() + ", machineIp=" + this.getMachineIp() + ", objectId=" + this.getObjectId() + ", objectType=" + this.getObjectType() + ", objectOperation=" + this.getObjectOperation() + ", objectOperationDetail=" + this.getObjectOperationDetail() + ", requestBody=" + this.getRequestBody() + ", clientId=" + this.getClientId() + ", costTime=" + this.getCostTime() + ", responseStatus=" + this.getResponseStatus() + ")";
    }

    public MetricEvent(String eventId, String requestId, String scheme, String httpMethod, String host, String uri, String path, String serviceName, String eventType, Integer status, String loginId, Long tenantId, String tenantName, Long accountId, String userName, Long userId, String tel, String email, String resourceId, String resourceType, String resourceCode, String resourceName, boolean admin, Boolean isRead, String ip, Date eventTime, String machineHostName, String machineIp, String objectId, String objectType, String objectOperation, String objectOperationDetail, String requestBody, String clientId, Long costTime, Integer responseStatus) {
        this.eventId = eventId;
        this.requestId = requestId;
        this.scheme = scheme;
        this.httpMethod = httpMethod;
        this.host = host;
        this.uri = uri;
        this.path = path;
        this.serviceName = serviceName;
        this.eventType = eventType;
        this.status = status;
        this.loginId = loginId;
        this.tenantId = tenantId;
        this.tenantName = tenantName;
        this.accountId = accountId;
        this.userName = userName;
        this.userId = userId;
        this.tel = tel;
        this.email = email;
        this.resourceId = resourceId;
        this.resourceType = resourceType;
        this.resourceCode = resourceCode;
        this.resourceName = resourceName;
        this.admin = admin;
        this.isRead = isRead;
        this.ip = ip;
        this.eventTime = eventTime;
        this.machineHostName = machineHostName;
        this.machineIp = machineIp;
        this.objectId = objectId;
        this.objectType = objectType;
        this.objectOperation = objectOperation;
        this.objectOperationDetail = objectOperationDetail;
        this.requestBody = requestBody;
        this.clientId = clientId;
        this.costTime = costTime;
        this.responseStatus = responseStatus;
    }

    public MetricEvent() {
    }

    public static class Builder {
        private URI uri;
        private UserSessionInfo userInfo;
        private String serviceName;
        private String httpMethod;
        private String resourceId;
        private String resourceType;
        private String eventType;
        private String clientId;
        private Long tenantId;
        private String tenantName;
        private Long costTime;
        private Integer responseStatus;

        public Builder tenantId(Long tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder tenantName(String tenantName) {
            this.tenantName = tenantName;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder costTime(Long costTime) {
            this.costTime = costTime;
            return this;
        }

        public Builder responseStatus(Integer responseStatus) {
            this.responseStatus = responseStatus;
            return this;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder userInfo(UserSessionInfo userInfo) {
            this.userInfo = userInfo;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public MetricEvent build() {
            return new MetricEvent(this);
        }
    }
}

