/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.config;

import com.xforceplus.action.trail.config.ThreadPoolConfigProps;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableConfigurationProperties(value={ThreadPoolConfigProps.class})
public class AtThreadPoolConfig {
    private static final String THREAD_NAME_PREFIX = "ActionTrail-";
    @Autowired
    private ThreadPoolConfigProps poolConfigProps;

    @Bean(name={"atExecutor"})
    public Executor getAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.poolConfigProps.getCorePoolSize());
        executor.setMaxPoolSize(this.poolConfigProps.getMaxPoolSize());
        executor.setQueueCapacity(this.poolConfigProps.getQueueCapacity());
        executor.setThreadNamePrefix(THREAD_NAME_PREFIX);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }
}

