/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.reactor.filters;

import com.xforceplus.action.trail.config.MachineInfo;
import com.xforceplus.action.trail.service.ActionTrailService;
import com.xforceplus.action.trail.vo.EventExtendInfo;
import com.xforceplus.action.trail.vo.MetricEvent;
import com.xforceplus.action.trail.vo.QueueElem;
import com.xforceplus.tenant.security.core.domain.AuthorizedUser;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.token.domain.UserType;
import io.geewit.web.utils.JsonUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.InflaterInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import org.springframework.util.Base64Utils;

@Service
public class ActionTrailAsync {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Integer> trailUris = new HashMap<String, Integer>();
    private ReadWriteLock trailUrisLock = new ReentrantReadWriteLock();
    @Autowired
    private ActionTrailService actionTrailService;
    @Autowired
    private MachineInfo machineInfo;
    @Value(value="${action.trail.queue-size:1024}")
    private int queueSize;
    @Value(value="${action.trail.url}")
    private String url;
    @Value(value="${spring.application.name:}")
    private String serviceName;
    private BlockingQueue<QueueElem> actionsQueue = new LinkedBlockingDeque<QueueElem>();

    public boolean enqueue(QueueElem elem) {
        return this.actionsQueue.add(elem);
    }

    public String uriFormatter(String method, String path) {
        StringBuffer sb = new StringBuffer();
        sb.append(method);
        sb.append("++++");
        sb.append(path);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrailUris(List<String> uris) {
        Lock writeLock = this.trailUrisLock.writeLock();
        writeLock.lock();
        try {
            this.trailUris.clear();
            for (String elem : uris) {
                this.trailUris.put(elem, 1);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public void pollQueueAndSave() {
        ArrayList<MetricEvent> events = new ArrayList<MetricEvent>(this.queueSize);
        while (true) {
            events.clear();
            try {
                QueueElem elem = this.actionsQueue.take();
                if (!this.checkNeedTrail(elem.getRequest())) continue;
                MetricEvent me = this.generateMetricEvent(elem);
                if (me != null) {
                    events.add(me);
                }
                while (events.size() < this.queueSize && (elem = (QueueElem)this.actionsQueue.poll()) != null) {
                    if (!this.checkNeedTrail(elem.getRequest()) || (me = this.generateMetricEvent(elem)) == null) continue;
                    events.add(me);
                }
                if (events.isEmpty()) continue;
                this.actionTrailService.saveActions(events);
                continue;
            }
            catch (InterruptedException e) {
                this.logger.warn("Exception occured while polling from source file.", (Throwable)e);
                continue;
            }
            catch (Exception e) {
                this.logger.error("Unknown Exception in pollQueueAndSave.", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private boolean checkNeedTrail(ServerHttpRequest request) {
        return true;
    }

    private MetricEvent generateMetricEvent(QueueElem queueElem) {
        this.logger.debug("generateMetricEvent. Path = {}", (Object)queueElem.getRequest().getURI().getPath());
        ServerHttpRequest request = queueElem.getRequest();
        Route gatewayRoute = queueElem.getGatewayRoute();
        EventExtendInfo eventExtendInfo = queueElem.getEventExtendInfo();
        String userinfo = request.getHeaders().getFirst(UserType.USER.userinfoKey());
        IAuthorizedUser user = null;
        user = StringUtils.isBlank((CharSequence)userinfo) ? null : (IAuthorizedUser)JsonUtils.fromJson((String)ActionTrailAsync.decode(userinfo), AuthorizedUser.class);
        if (user == null && StringUtils.isBlank((CharSequence)eventExtendInfo.getClientId())) {
            return null;
        }
        URI uri = gatewayRoute.getUri();
        HttpMethod method = request.getMethod();
        String traceId = request.getHeaders().getFirst("T_TRACE_ID");
        MetricEvent metricEvent = new MetricEvent.Builder().uri(uri).tenantId(eventExtendInfo.getTenantId() == null ? null : Long.valueOf(Long.parseLong(eventExtendInfo.getTenantId()))).tenantName(eventExtendInfo.getTenantName()).userInfo(user).clientId(eventExtendInfo.getClientId()).costTime(eventExtendInfo.getCostTime()).responseStatus(eventExtendInfo.getResponseStatus()).httpMethod(method.name()).eventId(traceId).eventType(method.name()).build();
        metricEvent.setPath(request.getPath().value());
        metricEvent.setUri(request.getURI().toString());
        metricEvent.setIp(eventExtendInfo.getRealRemoteIp());
        metricEvent.setRequestBody(eventExtendInfo.getRequestBody());
        metricEvent.setServiceName(this.serviceName);
        if (!eventExtendInfo.isUdConfig()) {
            metricEvent.setMachineHostName(this.machineInfo.getHostName());
            metricEvent.setMachineIp(this.machineInfo.getIp());
            metricEvent.setResourceId(eventExtendInfo.getResourceId());
            metricEvent.setResourceCode(eventExtendInfo.getResourceCode());
            metricEvent.setResourceName(eventExtendInfo.getResourceName());
            metricEvent.setResourceType(eventExtendInfo.getResourceType());
        }
        return metricEvent;
    }

    public static String decode(String base64) {
        byte[] compressed = Base64Utils.decodeFromString((String)base64);
        try {
            byte[] uncompressed = ActionTrailAsync.uncompress(compressed);
            return new String(uncompressed, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] uncompress(byte[] value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream bais = new ByteArrayInputStream(value);
        InflaterInputStream iis = new InflaterInputStream(bais);
        byte[] buf = new byte[1024];
        while (true) {
            int c;
            if ((c = iis.read(buf)) == -1) {
                baos.flush();
                return baos.toByteArray();
            }
            baos.write(buf, 0, c);
        }
    }
}

