/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.service.impl;

import com.xforceplus.action.trail.client.SaveMessageClient;
import com.xforceplus.action.trail.service.ActionTrailService;
import com.xforceplus.action.trail.vo.MetricEvent;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActionTrailServiceImpl
implements ActionTrailService {
    private static final Logger log = LoggerFactory.getLogger(ActionTrailServiceImpl.class);
    @Autowired
    private SaveMessageClient saveMessageClient;

    @Override
    public void saveAction(MetricEvent metricEvent) {
        try {
            this.saveMessageClient.saveAction(metricEvent, metricEvent.getTenantId());
        }
        catch (Exception e) {
            log.error("SaveAction error", (Throwable)e);
        }
    }

    @Override
    public void saveActions(List<MetricEvent> metricEvents) {
        try {
            log.info("Save Actions. Events Num = {}", (Object)metricEvents.size());
            this.saveMessageClient.saveMessagesInner(metricEvents);
        }
        catch (Exception e) {
            log.error("SaveActions error", (Throwable)e);
        }
    }
}

